/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.util.Arrays;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class NEISetCraftingRecipe
extends CoordinatesPacket {
    private ItemStack[] content = new ItemStack[9];

    public NEISetCraftingRecipe(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity tile = this.getTile(player.field_70170_p, TileEntity.class);
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).handleNEIRecipePacket(this.getContent());
        } else if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)tile).pipe).handleNEIRecipePacket(this.getContent());
        }
    }

    @Override
    public ModernPacket template() {
        return new NEISetCraftingRecipe(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.content.length);
        for (int i = 0; i < this.content.length; ++i) {
            ItemStack itemstack = this.content[i];
            if (itemstack == null || itemstack.func_190926_b()) continue;
            output.writeByte(i);
            output.writeInt(Item.func_150891_b((Item)itemstack.func_77973_b()));
            output.writeInt(itemstack.func_190916_E());
            output.writeInt(itemstack.func_77952_i());
            output.writeNBTTagCompound(itemstack.func_77978_p());
        }
        output.writeByte(-1);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.content = new ItemStack[input.readInt()];
        Arrays.fill(this.content, ItemStack.field_190927_a);
        byte index = input.readByte();
        while (index != -1) {
            int itemID = input.readInt();
            int stackSize = input.readInt();
            int damage = input.readInt();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)itemID), stackSize, damage);
            stack.func_77982_d(input.readNBTTagCompound());
            this.content[index] = stack;
            index = input.readByte();
        }
    }

    public ItemStack[] getContent() {
        return this.content;
    }

    public NEISetCraftingRecipe setContent(ItemStack[] content) {
        this.content = content;
        return this;
    }
}

