/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class DebugTargetResponse
extends ModernPacket {
    private TargetMode mode;
    private int[] additions = new int[0];

    public DebugTargetResponse(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.mode = TargetMode.values()[input.readByte()];
        this.additions = input.readIntArray();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (this.mode == TargetMode.None) {
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No Target Found"));
        } else if (this.mode == TargetMode.Block) {
            int x = this.additions[0];
            int y = this.additions[1];
            int z = this.additions[2];
            player.func_145747_a((ITextComponent)new TextComponentString("Checking Block at: x:" + x + " y:" + y + " z:" + z));
            Block id = player.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            player.func_145747_a((ITextComponent)new TextComponentString("Found Block with Id: " + id.getClass()));
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
            if (tile == null) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No TileEntity found"));
            } else {
                LPChatListener.addTask(() -> {
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Starting debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName()));
                    DebugGuiController.instance().startWatchingOf(tile, player);
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                    return true;
                }, (ICommandSender)player);
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.AQUA) + "Start debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        } else if (this.mode == TargetMode.Entity) {
            int entityId = this.additions[0];
            Entity entity = player.field_70170_p.func_73045_a(entityId);
            if (entity == null) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No Entity found"));
            } else {
                LPChatListener.addTask(() -> {
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Starting debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entity.getClass().getSimpleName()));
                    DebugGuiController.instance().startWatchingOf(entity, player);
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                    return true;
                }, (ICommandSender)player);
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.AQUA) + "Start debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entity.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeByte(this.mode.ordinal());
        output.writeIntArray(this.additions);
    }

    @Override
    public ModernPacket template() {
        return new DebugTargetResponse(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public TargetMode getMode() {
        return this.mode;
    }

    public DebugTargetResponse setMode(TargetMode mode) {
        this.mode = mode;
        return this;
    }

    public int[] getAdditions() {
        return this.additions;
    }

    public DebugTargetResponse setAdditions(int[] additions) {
        this.additions = additions;
        return this;
    }

    public static enum TargetMode {
        Block,
        Entity,
        None;

    }
}

