/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.multiblock;

import java.util.List;
import java.util.Set;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@StaticResolve
public class MultiBlockCoordinatesPacket
extends CoordinatesPacket {
    private Set<DoubleCoordinates> targetPos;
    private List<CoreMultiBlockPipe.SubBlockTypeForShare> subTypes;

    public MultiBlockCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeCollection(this.targetPos);
        output.writeCollection(this.subTypes, LPDataOutput::writeEnum);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.targetPos = input.readSet(DoubleCoordinates::new);
        this.subTypes = input.readArrayList(data1 -> data1.readEnum(CoreMultiBlockPipe.SubBlockTypeForShare.class));
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericSubMultiBlock block = this.getTile(player.func_130014_f_(), LogisticsTileGenericSubMultiBlock.class);
        block.setPosition(this.targetPos, this.subTypes);
    }

    @Override
    public ModernPacket template() {
        return new MultiBlockCoordinatesPacket(this.getId());
    }

    public Set<DoubleCoordinates> getTargetPos() {
        return this.targetPos;
    }

    public MultiBlockCoordinatesPacket setTargetPos(Set<DoubleCoordinates> targetPos) {
        this.targetPos = targetPos;
        return this;
    }

    public List<CoreMultiBlockPipe.SubBlockTypeForShare> getSubTypes() {
        return this.subTypes;
    }

    public MultiBlockCoordinatesPacket setSubTypes(List<CoreMultiBlockPipe.SubBlockTypeForShare> subTypes) {
        this.subTypes = subTypes;
        return this;
    }
}

