/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.Iterator;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.packets.pipe.SlotFinderActivatePacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.StaticResolve;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

@StaticResolve
public class SlotFinderOpenGuiPacket
extends ModuleCoordinatesPacket {
    private int slot;

    public SlotFinderOpenGuiPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        int i;
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(player.field_70170_p, this.getPosX(), this.getPosY(), this.getPosZ());
        Iterator adjacentIter = worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).iterator();
        boolean found = false;
        while (adjacentIter.hasNext()) {
            NeighborTileEntity adjacent = (NeighborTileEntity)adjacentIter.next();
            if (adjacent.isItemHandler() && !(adjacent.getInventoryUtil() instanceof ISpecialInsertion)) continue;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui((TileEntity)adjacent.getTileEntity())) continue;
                found = true;
                break;
            }
            if (!found) {
                found = adjacent.isItemHandler();
            }
            if (!found) continue;
            Block block = adjacent.getTileEntity().func_145838_q();
            BlockPos blockPos = adjacent.getTileEntity().func_174877_v();
            DoubleCoordinates pos = new DoubleCoordinates(blockPos);
            int xCoord = blockPos.func_177958_n();
            int yCoord = blockPos.func_177956_o();
            int zCoord = blockPos.func_177952_p();
            if (SimpleServiceLocator.enderStorageProxy.isEnderChestBlock(block)) {
                SimpleServiceLocator.enderStorageProxy.openEnderChest(player.field_70170_p, xCoord, yCoord, zCoord, player);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(xCoord).setTagetPosY(yCoord).setTagetPosZ(zCoord).setSlot(this.getSlot()).setPacketPos(this), player);
            }
            if (block == null || !block.func_180639_a(player.field_70170_p, pos.getBlockPos(), pos.getBlockState((IBlockAccess)player.field_70170_p), player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f)) continue;
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(xCoord).setTagetPosY(yCoord).setTagetPosZ(zCoord).setSlot(this.getSlot()).setPacketPos(this), player);
            break;
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderOpenGuiPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.slot);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.slot = input.readInt();
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderOpenGuiPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

