/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.interfaces.ISpecialTankUtil;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsFluidOrder;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class PipeFluidProvider
extends FluidRoutedPipe
implements IProvideFluids {
    public PipeFluidProvider(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this.getFluidOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) || !this.isNthTick(6)) {
            return;
        }
        LogisticsFluidOrder order = (LogisticsFluidOrder)this.getFluidOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER);
        AtomicInteger amountToSend = new AtomicInteger();
        AtomicInteger attemptedAmount = new AtomicInteger();
        amountToSend.set(Math.min(order.getAmount(), 5000));
        attemptedAmount.set(Math.min(order.getAmount(), 5000));
        for (Triplet<ITankUtil, TileEntity, EnumFacing> pair : this.getAdjacentTanksAdvanced(false)) {
            if (amountToSend.get() <= 0) break;
            ITankUtil util = (ITankUtil)pair.getValue1();
            boolean fallback = true;
            if (util instanceof ISpecialTankUtil) {
                TileEntity tile;
                fallback = false;
                ISpecialTankAccessHandler handler = ((ISpecialTankUtil)util).getSpecialHandler();
                FluidStack drained = handler.drainFrom(tile = ((ISpecialTankUtil)util).getTileEntity(), order.getFluid(), amountToSend.get(), false);
                if (drained != null && drained.amount > 0 && order.getFluid().equals(FluidIdentifier.get(drained))) {
                    drained = handler.drainFrom(tile, order.getFluid(), amountToSend.get(), true);
                    int amount = drained.amount;
                    amountToSend.addAndGet(-amount);
                    ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(FluidIdentifierStack.getFromStack(drained));
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                    item.setDestination(order.getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    this.queueRoutedItem(item, pair.getValue3());
                    this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                    if (amountToSend.get() <= 0) break;
                }
            }
            if (!fallback || !util.containsTanks()) continue;
            util.forEachFluid(fluidStack -> {
                int amount;
                FluidIdentifierStack drained;
                if (amountToSend.get() <= 0) {
                    return;
                }
                if (fluidStack.getFluid() != null && order.getFluid().equals(fluidStack.getFluid()) && (drained = util.drain(amount = Math.min(fluidStack.getAmount(), amountToSend.get()), false)) != null && drained.getAmount() > 0 && order.getFluid().equals(drained.getFluid())) {
                    FluidIdentifierStack addition;
                    drained = util.drain(amount, true);
                    while (drained.getAmount() < amountToSend.get() && (addition = util.drain(amountToSend.get() - drained.getAmount(), false)) != null && addition.getAmount() > 0 && order.getFluid().equals(addition.getFluid())) {
                        addition = util.drain(amountToSend.get() - drained.getAmount(), true);
                        drained.raiseAmount(addition.getAmount());
                    }
                    amount = drained.getAmount();
                    amountToSend.addAndGet(-amount);
                    ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                    item.setDestination(order.getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    this.queueRoutedItem(item, (EnumFacing)pair.getValue3());
                    this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                }
            });
        }
        if (amountToSend.get() >= attemptedAmount.get()) {
            this.getFluidOrderManager().sendFailed();
        }
    }

    @Override
    public Map<FluidIdentifier, Integer> getAvailableFluids() {
        HashMap<FluidIdentifier, Integer> map = new HashMap<FluidIdentifier, Integer>();
        for (Triplet<ITankUtil, TileEntity, EnumFacing> pair : this.getAdjacentTanksAdvanced(false)) {
            ITankUtil util = (ITankUtil)pair.getValue1();
            boolean fallback = true;
            if (util instanceof ISpecialTankUtil) {
                fallback = false;
                ISpecialTankAccessHandler handler = ((ISpecialTankUtil)util).getSpecialHandler();
                TileEntity tile = ((ISpecialTankUtil)util).getTileEntity();
                Map<FluidIdentifier, Long> tmp = handler.getAvailableLiquid(tile);
                for (Map.Entry<FluidIdentifier, Long> entry : tmp.entrySet()) {
                    if (map.containsKey(entry.getKey())) {
                        long addition = (long)((Integer)map.get(entry.getKey())).intValue() + entry.getValue();
                        map.put(entry.getKey(), addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                        continue;
                    }
                    map.put(entry.getKey(), entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : entry.getValue().intValue());
                }
            }
            if (!fallback || !util.containsTanks()) continue;
            util.forEachFluid(liquid -> {
                FluidIdentifier ident;
                if (liquid.getFluid() != null && util.canDrain(ident = liquid.getFluid()) && util.drain(ident.makeFluidIdentifierStack(1), false) != null) {
                    if (map.containsKey(ident)) {
                        long addition = (long)((Integer)map.get(ident)).intValue() + (long)liquid.getAmount();
                        map.put(ident, addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                    } else {
                        map.put(ident, liquid.getAmount());
                    }
                }
            });
        }
        HashMap<FluidIdentifier, Integer> result = new HashMap<FluidIdentifier, Integer>();
        for (Map.Entry fluid : map.entrySet()) {
            int remaining = (Integer)fluid.getValue() - this.getFluidOrderManager().totalFluidsCountInOrders((FluidIdentifier)fluid.getKey());
            if (remaining < 1) continue;
            result.put((FluidIdentifier)fluid.getKey(), remaining);
        }
        return result;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_PROVIDER;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filter) {
        if (tree.isDone()) {
            return;
        }
        if (!(tree.getRequestType() instanceof FluidResource)) {
            return;
        }
        FluidIdentifier fluid = ((FluidResource)tree.getRequestType()).getFluid();
        AtomicInteger containedAmount = new AtomicInteger(0);
        for (Triplet<ITankUtil, TileEntity, EnumFacing> pair : this.getAdjacentTanksAdvanced(false)) {
            ITankUtil util = (ITankUtil)pair.getValue1();
            boolean fallback = true;
            if (util instanceof ISpecialTankUtil) {
                TileEntity tile;
                fallback = false;
                ISpecialTankAccessHandler handler = ((ISpecialTankUtil)util).getSpecialHandler();
                Map<FluidIdentifier, Long> map = handler.getAvailableLiquid(tile = ((ISpecialTankUtil)util).getTileEntity());
                if (map.containsKey(fluid)) {
                    long addition = (long)containedAmount.get() + map.get(fluid);
                    containedAmount.set(addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                }
            }
            if (!fallback || !util.containsTanks()) continue;
            util.forEachFluid(liquid -> {
                if (liquid.getFluid() != null && fluid.equals(liquid.getFluid()) && util.canDrain(liquid.getFluid()) && util.drain(liquid.getFluid().makeFluidIdentifierStack(1), false) != null) {
                    long addition = (long)containedAmount.get() + (long)liquid.getAmount();
                    containedAmount.set(addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                }
            });
        }
        FluidLogisticsPromise promise = new FluidLogisticsPromise();
        promise.liquid = fluid;
        promise.amount = Math.min(tree.getMissingAmount(), containedAmount.get() - root.getAllPromissesFor(this, fluid.getItemIdentifier()));
        promise.sender = this;
        promise.type = IOrderInfoProvider.ResourceType.PROVIDER;
        if (promise.amount > 0) {
            tree.addPromise(promise);
        }
    }

    @Override
    public IOrderInfoProvider fullFill(FluidLogisticsPromise promise, IRequestFluid destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        return this.getFluidOrderManager().addOrder(promise, destination, type, info);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (Triplet<ITankUtil, TileEntity, EnumFacing> pair : this.getAdjacentTanksAdvanced(false)) {
            ITankUtil util = (ITankUtil)pair.getValue1();
            boolean fallback = true;
            if (util instanceof ISpecialTankUtil) {
                fallback = false;
                ISpecialTankAccessHandler handler = ((ISpecialTankUtil)util).getSpecialHandler();
                TileEntity tile = ((ISpecialTankUtil)util).getTileEntity();
                Map<FluidIdentifier, Long> map = handler.getAvailableLiquid(tile);
                l1.addAll(map.keySet().stream().map(FluidIdentifier::getItemIdentifier).collect(Collectors.toList()));
            }
            if (!fallback || !util.containsTanks()) continue;
            util.forEachFluid(liquid -> {
                if (liquid.getFluid() != null && util.canDrain(liquid.getFluid()) && util.drain(1, false) != null) {
                    FluidIdentifier ident = liquid.getFluid();
                    l1.add(ident.getItemIdentifier());
                }
            });
        }
        return l1;
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

