/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.multiblock.MultiBlockCoordinatesPacket;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.renderer.state.PipeSubRenderState;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.ISubMultiBlockPipeInformationProvider;
import logisticspipes.utils.TileBuffer;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LogisticsTileGenericSubMultiBlock
extends TileEntity
implements ISubMultiBlockPipeInformationProvider,
ITickable {
    private Set<DoubleCoordinates> mainPipePos = new HashSet<DoubleCoordinates>();
    private List<LogisticsTileGenericPipe> mainPipe;
    private List<CoreMultiBlockPipe.SubBlockTypeForShare> subTypes = new ArrayList<CoreMultiBlockPipe.SubBlockTypeForShare>();
    private TileBuffer[] tileBuffer;
    public final PipeSubRenderState renderState;

    @Deprecated
    public LogisticsTileGenericSubMultiBlock() {
        this.renderState = new PipeSubRenderState();
    }

    public LogisticsTileGenericSubMultiBlock(DoubleCoordinates pos) {
        if (pos != null) {
            this.mainPipePos.add(pos);
        }
        this.mainPipe = null;
        this.renderState = new PipeSubRenderState();
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (MainProxy.isClient()) {
            System.out.println("Multi Pipe Created at: " + posIn);
        }
    }

    public List<LogisticsTileGenericPipe> getMainPipe() {
        if (this.mainPipe == null) {
            this.mainPipe = new ArrayList<LogisticsTileGenericPipe>();
            for (DoubleCoordinates pos : this.mainPipePos) {
                TileEntity tile = pos.getTileEntity((IBlockAccess)this.func_145831_w());
                if (!(tile instanceof LogisticsTileGenericPipe)) continue;
                this.mainPipe.add((LogisticsTileGenericPipe)tile);
            }
            this.mainPipe = Collections.unmodifiableList(this.mainPipe);
        }
        if (MainProxy.isServer((IBlockAccess)this.field_145850_b)) {
            boolean allInvalid = true;
            for (LogisticsTileGenericPipe pipe : this.mainPipe) {
                if (pipe.func_145837_r()) continue;
                allInvalid = false;
                break;
            }
            if (this.mainPipe.isEmpty() || allInvalid) {
                this.func_145831_w().func_175698_g(this.func_174877_v());
            }
        }
        if (this.mainPipe != null) {
            return this.mainPipe;
        }
        return Collections.emptyList();
    }

    public List<CoreMultiBlockPipe.SubBlockTypeForShare> getSubTypes() {
        return Collections.unmodifiableList(this.subTypes);
    }

    public void func_73660_a() {
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            return;
        }
        List<LogisticsTileGenericPipe> pipes = this.getMainPipe();
        for (LogisticsTileGenericPipe pipe : pipes) {
            pipe.subMultiBlock.add(new DoubleCoordinates(this));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("MainPipePos_xPos")) {
            this.mainPipePos.clear();
            DoubleCoordinates pos = DoubleCoordinates.readFromNBT("MainPipePos_", nbt);
            if (pos != null) {
                this.mainPipePos.add(pos);
            }
        }
        if (nbt.func_74764_b("MainPipePosList")) {
            list = nbt.func_150295_c("MainPipePosList", (int)new NBTTagCompound().func_74732_a());
            for (i = 0; i < list.func_74745_c(); ++i) {
                DoubleCoordinates pos = DoubleCoordinates.readFromNBT("MainPipePos_", list.func_150305_b(i));
                if (pos == null) continue;
                this.mainPipePos.add(pos);
            }
        }
        if (nbt.func_74764_b("SubTypeList")) {
            list = nbt.func_150295_c("SubTypeList", (int)new NBTTagString().func_74732_a());
            this.subTypes.clear();
            for (i = 0; i < list.func_74745_c(); ++i) {
                String name = list.func_150307_f(i);
                CoreMultiBlockPipe.SubBlockTypeForShare type = CoreMultiBlockPipe.SubBlockTypeForShare.valueOf(name);
                if (type == null) continue;
                this.subTypes.add(type);
            }
        }
        this.mainPipe = null;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        NBTTagList nbtList = new NBTTagList();
        for (DoubleCoordinates pos : this.mainPipePos) {
            NBTTagCompound compound = new NBTTagCompound();
            pos.writeToNBT("MainPipePos_", compound);
            nbtList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("MainPipePosList", (NBTBase)nbtList);
        NBTTagList nbtTypeList = new NBTTagList();
        for (CoreMultiBlockPipe.SubBlockTypeForShare type : this.subTypes) {
            if (type == null) continue;
            nbtTypeList.func_74742_a((NBTBase)new NBTTagString(type.name()));
        }
        nbt.func_74782_a("SubTypeList", (NBTBase)nbtTypeList);
        return nbt;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        try {
            PacketHandler.addPacketToNBT(this.getLPDescriptionPacket(), nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        PacketHandler.queueAndRemovePacketFromNBT(tag);
        super.handleUpdateTag(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            PacketHandler.addPacketToNBT(this.getLPDescriptionPacket(), nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        PacketHandler.queueAndRemovePacketFromNBT(packet.func_148857_g());
    }

    public ModernPacket getLPDescriptionPacket() {
        MultiBlockCoordinatesPacket packet = PacketHandler.getPacket(MultiBlockCoordinatesPacket.class);
        packet.setTilePos(this);
        packet.setTargetPos(this.mainPipePos);
        packet.setSubTypes(this.subTypes);
        return packet;
    }

    public void setPosition(Set<DoubleCoordinates> lpPosition, List<CoreMultiBlockPipe.SubBlockTypeForShare> subTypes) {
        this.mainPipePos = lpPosition;
        this.subTypes = subTypes;
        this.mainPipe = null;
    }

    public TileEntity getTile() {
        return this;
    }

    public TileEntity getTile(EnumFacing to) {
        return this.getTile(to, false);
    }

    public TileEntity getTile(EnumFacing to, boolean force) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            if (force) {
                cache[to.ordinal()].refresh();
            }
            return cache[to.ordinal()].getTile();
        }
        return null;
    }

    public Block getBlock(EnumFacing to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlock();
        }
        return null;
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.func_174877_v(), true);
        }
        return this.tileBuffer;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.tileBuffer = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tileBuffer = null;
    }

    public void scheduleNeighborChange() {
        this.tileBuffer = null;
    }

    public void addSubTypeTo(CoreMultiBlockPipe.SubBlockTypeForShare type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.subTypes.add(type);
    }

    public void addMultiBlockMainPos(DoubleCoordinates placeAt) {
        if (this.mainPipePos.add(placeAt)) {
            this.mainPipe = null;
        }
    }

    public boolean removeMainPipe(DoubleCoordinates doubleCoordinates) {
        this.mainPipePos.remove(doubleCoordinates);
        return this.mainPipePos.isEmpty();
    }

    public void removeSubType(CoreMultiBlockPipe.SubBlockTypeForShare type) {
        this.subTypes.remove((Object)type);
    }

    @Override
    public IPipeInformationProvider getMainTile() {
        List<LogisticsTileGenericPipe> mainTiles = this.getMainPipe();
        if (mainTiles.size() != 1) {
            return null;
        }
        return mainTiles.get(0);
    }
}

