/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.UpgradeCoordinatesGuiProvider;
import logisticspipes.network.guis.upgrade.DisconnectionUpgradeConfigGuiProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.IConfigPipeUpgrade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class ConnectionUpgradeConfig
implements IConfigPipeUpgrade {
    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public boolean isAllowedForPipe(CoreRoutedPipe pipe) {
        return true;
    }

    @Override
    public boolean isAllowedForModule(LogisticsModule pipe) {
        return false;
    }

    @Override
    public String[] getAllowedPipes() {
        return new String[]{"all"};
    }

    @Override
    public String[] getAllowedModules() {
        return new String[0];
    }

    @Override
    public UpgradeCoordinatesGuiProvider getGUI() {
        return NewGuiHandler.getGui(DisconnectionUpgradeConfigGuiProvider.class);
    }

    public Stream<EnumFacing> getSides(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return Arrays.stream(Sides.values()).filter(side -> nbt.func_74767_n(side.getLpName())).map(Sides::getDir);
    }

    public static enum Sides {
        UP(EnumFacing.UP, "LPDIS-UP"),
        DOWN(EnumFacing.DOWN, "LPDIS-DOWN"),
        NORTH(EnumFacing.NORTH, "LPDIS-NORTH"),
        SOUTH(EnumFacing.SOUTH, "LPDIS-SOUTH"),
        EAST(EnumFacing.EAST, "LPDIS-EAST"),
        WEST(EnumFacing.WEST, "LPDIS-WEST");

        private EnumFacing dir;
        private String lpName;

        public static String getNameForDirection(EnumFacing fd) {
            Optional<Sides> opt = Arrays.stream(Sides.values()).filter(side -> side.getDir() == fd).findFirst();
            if (opt.isPresent()) {
                return opt.get().getLpName();
            }
            return "LPDIS-UNKNWON";
        }

        private Sides(EnumFacing dir, String lpName) {
            this.dir = dir;
            this.lpName = lpName;
        }

        public EnumFacing getDir() {
            return this.dir;
        }

        public String getLpName() {
            return this.lpName;
        }
    }
}

