/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.computers.objects;

import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.proxy.computers.interfaces.ICCTypeWrapped;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeDefinition;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.nbt.NBTTagCompound;

public class CCFluidIdentifier
implements ILPCCTypeDefinition {
    @Override
    public ICCTypeWrapped getTypeFor(Object ident) {
        return new CCFluidIdentifierImplementation((FluidIdentifier)ident);
    }

    @CCType(name="FluidIdentifier")
    public static class CCFluidIdentifierImplementation
    implements ICCTypeWrapped {
        final FluidIdentifier ident;

        public CCFluidIdentifierImplementation(FluidIdentifier ident2) {
            this.ident = ident2;
        }

        @CCCommand(description="Returns the fluidIdentifier of this FluidIdentifier")
        public String getId() {
            return this.ident.fluidID;
        }

        @CCCommand(description="Returns true if this FluidIdentifier has an tag")
        public boolean hasTagCompound() {
            return this.ident.tag != null;
        }

        @CCCommand(description="Returns the tag of this FluidIdentifier")
        public NBTTagCompound getTagCompound() {
            return this.ident.tag;
        }

        @CCCommand(description="Returns the Name of this FluidIdentifier")
        public String getName() {
            return this.ident.getName();
        }

        @CCCommand(description="Returns an ItemIdentifier if one exists for this FluidIdentifier")
        public ItemIdentifier getItemIdentifier() {
            return this.ident.getItemIdentifier();
        }

        @Override
        public FluidIdentifier getObject() {
            return this.ident;
        }
    }
}

