/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.proxy.specialinventoryhandler.LPActionSource;
import logisticspipes.proxy.specialinventoryhandler.LPStorageMonitorableAccessor;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class AEInterfaceInventoryHandler
extends SpecialInventoryHandler {
    public boolean init = false;
    private final boolean hideOnePerStack;
    private final TileEntity tile;
    private final EnumFacing dir;
    private final LPActionSource source;
    private IStorageMonitorableAccessor acc = null;
    IGridHost host;
    public IGridNode node;
    private LinkedList<Map.Entry<ItemIdentifier, Integer>> cached;

    private AEInterfaceInventoryHandler(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this.tile = tile;
        this.hideOnePerStack = hideOnePerStack || hideOne;
        this.acc = (IStorageMonitorableAccessor)tile.getCapability(LPStorageMonitorableAccessor.STORAGE_MONITORABLE_ACCESSOR_CAPABILITY, dir);
        this.node = ((IGridHost)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir));
        this.host = this.node.getMachine();
        this.source = new LPActionSource(this);
        this.dir = dir;
    }

    public AEInterfaceInventoryHandler() {
        this.tile = null;
        this.hideOnePerStack = false;
        this.source = null;
        this.dir = null;
    }

    @Override
    public boolean isType(TileEntity tile, EnumFacing dir) {
        if (tile instanceof IGridHost && tile.hasCapability(LPStorageMonitorableAccessor.STORAGE_MONITORABLE_ACCESSOR_CAPABILITY, dir)) {
            return ((IGridHost)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir)) != null;
        }
        return false;
    }

    @Override
    public boolean init() {
        this.init = true;
        return true;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new AEInterfaceInventoryHandler(tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap result = linked ? new LinkedHashMap() : new HashMap();
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return result;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            Integer count = (Integer)result.get(ident);
            if (count != null) {
                result.put((ItemIdentifier)ident, (int)((long)count.intValue() + item.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
                continue;
            }
            result.put((ItemIdentifier)ident, (int)(item.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
        }
        return result;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)item.makeNormalStack(1));
        IAEItemStack extract = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).extractItems((IAEStack)stack, Actionable.MODULATE, (IActionSource)this.source);
        if (extract == null) {
            return ItemStack.field_190927_a;
        }
        return extract.createItemStack();
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        if (this.itemCount(itemIdent) < count) {
            return ItemStack.field_190927_a;
        }
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemIdent.makeNormalStack(count));
        IAEItemStack extract = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).extractItems((IAEStack)stack, Actionable.MODULATE, (IActionSource)this.source);
        if (extract == null) {
            return ItemStack.field_190927_a;
        }
        return extract.createItemStack();
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return false;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            if (!ident.equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, item.getMaxStackSize());
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return 0;
        }
        while (count > 0) {
            IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemIdent.makeNormalStack(count));
            if (tmp.getInventory((IStorageChannel)channel).canAccept((IAEStack)stack)) {
                return count;
            }
            --count;
        }
        return 0;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return result;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            result.add(ident);
        }
        return result;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        if (this.cached.size() == 0) {
            return 1;
        }
        return this.cached.size();
    }

    private void initCache() {
        Map<ItemIdentifier, Integer> map = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        this.cached.addAll(map.entrySet());
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        Map.Entry<ItemIdentifier, Integer> entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((entry = this.cached.get(i)).getValue() == 0) {
            return ItemStack.field_190927_a;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        if (this.cached == null) {
            this.initCache();
        }
        Map.Entry<ItemIdentifier, Integer> entry = this.cached.get(i);
        ItemStack extracted = this.getMultipleItems(entry.getKey(), j);
        entry.setValue(entry.getValue() - j);
        return extracted;
    }

    @Override
    public ItemStack add(ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IAEItemStack tst = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return st;
        }
        IAEItemStack overflow = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).injectItems((IAEStack)tst, Actionable.MODULATE, (IActionSource)this.source);
        if (overflow != null) {
            st.func_190920_e((int)((long)st.func_190916_E() - overflow.getStackSize()));
        }
        return st;
    }
}

