/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import logisticspipes.blocks.LogisticsSolidBlock;
import logisticspipes.items.LogisticsSolidBlockItem;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.TextureTransformation;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.renderer.newpipe.LogisticsNewSolidBlockWorldRenderer;
import logisticspipes.renderer.newpipe.RenderEntry;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class LogisticsBlockModel
implements IModel {
    private final ResourceLocation inactive;
    private final ResourceLocation active;

    public LogisticsBlockModel(ResourceLocation texture, LogisticsSolidBlock.Type type) {
        this.inactive = texture;
        this.active = type.isHasActiveTexture() ? new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + "_active") : texture;
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(this.inactive, this.active);
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, final @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        final ArrayList quads = Lists.newArrayList();
        final TextureAtlasSprite inactiveT = bakedTextureGetter.apply(this.inactive);
        final TextureAtlasSprite activeT = bakedTextureGetter.apply(this.active);
        return new IBakedModel(){

            @Nonnull
            public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                if (side == null) {
                    if (quads.isEmpty()) {
                        quads.addAll(LogisticsRenderPipe.secondRenderer.getQuadsFromRenderList(LogisticsBlockModel.this.generateBlockRenderList(state, inactiveT, activeT), format, true));
                    }
                    return quads;
                }
                return Collections.emptyList();
            }

            public boolean func_177555_b() {
                return false;
            }

            public boolean func_177556_c() {
                return true;
            }

            public boolean func_188618_c() {
                return false;
            }

            @Nonnull
            public TextureAtlasSprite func_177554_e() {
                return inactiveT;
            }

            @Nonnull
            public ItemOverrideList func_188617_f() {
                return ItemOverrideList.field_188022_a;
            }

            @Nonnull
            public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)SimpleServiceLocator.cclProxy.getDefaultBlockState(), (ItemCameraTransforms.TransformType)cameraTransformType);
            }
        };
    }

    private List<RenderEntry> generateBlockRenderList(@Nullable IBlockState state, @Nonnull TextureAtlasSprite inactive, @Nonnull TextureAtlasSprite active) {
        TextureTransformation icon;
        ArrayList<RenderEntry> objectsToRender = new ArrayList<RenderEntry>();
        LogisticsNewSolidBlockWorldRenderer.BlockRotation rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.ZERO;
        if (state != null) {
            rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.getRotation((Integer)state.func_177229_b((IProperty)LogisticsSolidBlock.rotationProperty));
            icon = SimpleServiceLocator.cclProxy.createIconTransformer((Boolean)state.func_177229_b((IProperty)LogisticsSolidBlock.active) != false ? active : inactive);
        } else {
            icon = SimpleServiceLocator.cclProxy.createIconTransformer(inactive);
        }
        objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.block.get((Object)rotation), icon));
        for (LogisticsNewSolidBlockWorldRenderer.CoverSides side : LogisticsNewSolidBlockWorldRenderer.CoverSides.values()) {
            boolean render = true;
            if (state != null && !((Boolean)state.func_177229_b((IProperty)LogisticsSolidBlock.connectionPropertys.get(side.getDir(rotation)))).booleanValue()) {
                render = false;
            }
            if (!render) continue;
            objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.texturePlate_Outer.get((Object)side).get((Object)rotation), icon));
            objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.texturePlate_Inner.get((Object)side).get((Object)rotation), icon));
        }
        return objectsToRender;
    }

    public static class Loader
    implements ICustomModelLoader {
        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            return this.getType(modelLocation) != null;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            ResourceLocation baseTex = new ResourceLocation(modelLocation.func_110624_b(), "solid_block/" + modelLocation.func_110623_a());
            return new LogisticsBlockModel(baseTex, Objects.requireNonNull(this.getType(modelLocation)));
        }

        @Nullable
        private LogisticsSolidBlock.Type getType(ResourceLocation modelLocation) {
            if (!(modelLocation instanceof ModelResourceLocation)) {
                return null;
            }
            ResourceLocation clean = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
            String variant = ((ModelResourceLocation)modelLocation).func_177518_c();
            if (variant.equals("inventory")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(clean);
                if (item instanceof LogisticsSolidBlockItem) {
                    return ((LogisticsSolidBlockItem)item).getType();
                }
                return null;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(clean);
            if (block instanceof LogisticsSolidBlock) {
                return ((LogisticsSolidBlock)block).getType();
            }
            return null;
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }
    }
}

