/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.IClientState;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.newpipe.GLRenderList;
import logisticspipes.renderer.newpipe.RenderEntry;
import logisticspipes.renderer.state.ConnectionMatrix;
import logisticspipes.renderer.state.TextureMatrix;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class PipeRenderState
implements IClientState {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public List<RenderEntry> cachedRenderer = null;
    public Cache<LocalCacheType, Object> objectCache = CacheBuilder.newBuilder().build();
    public int cachedRenderIndex = -1;
    public boolean forceRenderOldPipe = false;
    private boolean[] solidSidesCache = new boolean[6];
    private boolean savedStateHasMCMultiParts = false;
    public int[] buffer = null;
    public Map<ResourceLocation, GLRenderList> renderLists;
    private boolean dirty = true;

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.clearRenderCaches();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty();
    }

    public void checkForRenderUpdate(IBlockAccess worldIn, BlockPos blockPos) {
        boolean hasParts;
        DoubleCoordinates pos;
        TileEntity tile;
        boolean[] solidSides = new boolean[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            DoubleCoordinates pos2 = CoordinateUtils.add(new DoubleCoordinates(blockPos), dir);
            IBlockState blockSide = pos2.getBlockState(worldIn);
            if (blockSide == null || !blockSide.isSideSolid(worldIn, pos2.getBlockPos(), dir.func_176734_d()) || this.pipeConnectionMatrix.isConnected(dir)) continue;
            solidSides[dir.ordinal()] = true;
        }
        if (!Arrays.equals(solidSides, this.solidSidesCache)) {
            this.solidSidesCache = (boolean[])solidSides.clone();
            this.clearRenderCaches();
        }
        if ((tile = (pos = new DoubleCoordinates(blockPos)).getTileEntity(worldIn)) instanceof LogisticsTileGenericPipe && this.savedStateHasMCMultiParts != (hasParts = SimpleServiceLocator.mcmpProxy.hasParts((LogisticsTileGenericPipe)tile))) {
            this.savedStateHasMCMultiParts = hasParts;
            this.clearRenderCaches();
        }
    }

    public void clearRenderCaches() {
        this.cachedRenderer = null;
        this.objectCache.invalidateAll();
        this.objectCache.cleanUp();
    }

    @Override
    public void writeData(LPDataOutput output) {
        this.pipeConnectionMatrix.writeData(output);
        this.textureMatrix.writeData(output);
    }

    @Override
    public void readData(LPDataInput input) {
        this.pipeConnectionMatrix.readData(input);
        this.textureMatrix.readData(input);
    }

    public static enum LocalCacheType {
        QUADS;

    }
}

