/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import logisticspipes.config.Configs;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class TextureMatrix {
    private final int[] iconIndexes = new int[7];
    private int textureIndex;
    private boolean isRouted;
    private boolean[] isRoutedInDir = new boolean[6];
    private boolean[] isSubPowerInDir = new boolean[6];
    private boolean hasPowerUpgrade;
    private boolean hasPower;
    private boolean isFluid;
    private EnumFacing pointedOrientation;
    private boolean dirty = true;

    public int getTextureIndex(EnumFacing direction) {
        return this.iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(EnumFacing direction, int value) {
        if (this.iconIndexes[direction.ordinal()] != value) {
            this.iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public void refreshStates(CoreUnroutedPipe pipe) {
        if (this.textureIndex != pipe.getTextureIndex()) {
            this.dirty = true;
        }
        this.textureIndex = pipe.getTextureIndex();
        if (this.isRouted != pipe.isRoutedPipe()) {
            this.dirty = true;
        }
        this.isRouted = pipe.isRoutedPipe();
        if (this.isRouted) {
            int i;
            CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe;
            for (i = 0; i < 6; ++i) {
                if (this.isRoutedInDir[i] != cPipe.getRouter().isRoutedExit(EnumFacing.func_82600_a((int)i))) {
                    this.dirty = true;
                }
                this.isRoutedInDir[i] = cPipe.getRouter().isRoutedExit(EnumFacing.func_82600_a((int)i));
            }
            for (i = 0; i < 6; ++i) {
                if (this.isSubPowerInDir[i] != cPipe.getRouter().isSubPoweredExit(EnumFacing.func_82600_a((int)i))) {
                    this.dirty = true;
                }
                this.isSubPowerInDir[i] = cPipe.getRouter().isSubPoweredExit(EnumFacing.func_82600_a((int)i));
            }
            if (this.hasPowerUpgrade != (cPipe.getUpgradeManager().hasRFPowerSupplierUpgrade() || cPipe.getUpgradeManager().getIC2PowerLevel() > 0)) {
                this.dirty = true;
            }
            this.hasPowerUpgrade = cPipe.getUpgradeManager().hasRFPowerSupplierUpgrade() || cPipe.getUpgradeManager().getIC2PowerLevel() > 0;
            if (this.hasPower != (cPipe._textureBufferPowered || Configs.LOGISTICS_POWER_USAGE_DISABLED)) {
                this.dirty = true;
            }
            boolean bl = this.hasPower = cPipe._textureBufferPowered || Configs.LOGISTICS_POWER_USAGE_DISABLED;
            if (this.isFluid != cPipe.isFluidPipe()) {
                this.dirty = true;
            }
            this.isFluid = cPipe.isFluidPipe();
            if (this.pointedOrientation != cPipe.getPointedOrientation()) {
                this.dirty = true;
            }
            this.pointedOrientation = cPipe.getPointedOrientation();
        } else {
            this.isRoutedInDir = new boolean[6];
        }
    }

    public boolean isRoutedInDir(EnumFacing dir) {
        if (dir == null) {
            return false;
        }
        return this.isRoutedInDir[dir.ordinal()];
    }

    public boolean isSubPowerInDir(EnumFacing dir) {
        if (dir == null) {
            return false;
        }
        return this.isSubPowerInDir[dir.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(LPDataOutput output) {
        for (int iconIndexe : this.iconIndexes) {
            output.writeByte(iconIndexe);
        }
        output.writeInt(this.textureIndex);
        output.writeBoolean(this.isRouted);
        output.writeBooleanArray(this.isRoutedInDir);
        output.writeBooleanArray(this.isSubPowerInDir);
        output.writeBoolean(this.hasPowerUpgrade);
        output.writeBoolean(this.hasPower);
        output.writeBoolean(this.isFluid);
        output.writeFacing(this.pointedOrientation);
    }

    public void readData(LPDataInput input) {
        for (int i = 0; i < this.iconIndexes.length; ++i) {
            byte icon = input.readByte();
            if (this.iconIndexes[i] == icon) continue;
            this.iconIndexes[i] = icon;
            this.dirty = true;
        }
        this.textureIndex = input.readInt();
        this.isRouted = input.readBoolean();
        this.isRoutedInDir = input.readBooleanArray();
        this.isSubPowerInDir = input.readBooleanArray();
        this.hasPowerUpgrade = input.readBoolean();
        this.hasPower = input.readBoolean();
        this.isFluid = input.readBoolean();
        this.pointedOrientation = input.readFacing();
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public boolean isRouted() {
        return this.isRouted;
    }

    public boolean isHasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public boolean isHasPower() {
        return this.hasPower;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public EnumFacing getPointedOrientation() {
        return this.pointedOrientation;
    }
}

