/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import logisticspipes.asm.addinfo.IAddInfo;
import logisticspipes.asm.addinfo.IAddInfoProvider;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidIdentifier
implements Comparable<FluidIdentifier>,
ILPCCTypeHolder {
    private static final ReadWriteLock dblock = new ReentrantReadWriteLock();
    private static final Lock rlock = dblock.readLock();
    private static final Lock wlock = dblock.writeLock();
    private static final HashMap<Integer, FluidIdentifier> _fluidIdentifierIdCache = new HashMap(256, 0.5f);
    private static final Map<String, HashMap<FinalNBTTagCompound, FluidIdentifier>> _fluidIdentifierTagCache = new HashMap<String, HashMap<FinalNBTTagCompound, FluidIdentifier>>(256);
    private static final Map<String, FluidIdentifier> _fluidIdentifierCache = new HashMap<String, FluidIdentifier>(256);
    public final String fluidID;
    public final String name;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private static boolean init = false;
    private Object ccObject;

    @Override
    public int compareTo(FluidIdentifier o) {
        int c = this.fluidID.compareTo(o.fluidID);
        if (c != 0) {
            return c;
        }
        c = this.uniqueID - o.uniqueID;
        return c;
    }

    private FluidIdentifier(String fluidID, String name, FinalNBTTagCompound tag, int uniqueID) {
        this.fluidID = fluidID;
        this.name = name;
        this.tag = tag;
        this.uniqueID = uniqueID;
    }

    public static FluidIdentifier get(Fluid fluid, NBTTagCompound tag, FluidIdentifier proposal) {
        FinalNBTTagCompound tagwithfixedname;
        FluidIdentifier unknownFluid;
        String fluidID = fluid.getName();
        if (tag == null) {
            FluidIdentifier ident;
            FluidAddInfo info;
            if (proposal != null && proposal.fluidID.equals(fluidID) && proposal.tag == null) {
                return proposal;
            }
            proposal = null;
            IAddInfoProvider prov = null;
            if (fluid instanceof IAddInfoProvider && (info = (prov = (IAddInfoProvider)fluid).getLogisticsPipesAddInfo(FluidAddInfo.class)) != null) {
                proposal = info.fluid;
            }
            if (proposal != (ident = FluidIdentifier.getFluidIdentifierWithoutTag(fluid, fluidID, proposal)) && prov != null) {
                prov.setLogisticsPipesAddInfo(new FluidAddInfo(ident));
            }
            return ident;
        }
        rlock.lock();
        HashMap fluidNBTList = _fluidIdentifierTagCache.get(fluidID);
        if (fluidNBTList != null && (unknownFluid = fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            rlock.unlock();
            return unknownFluid;
        }
        rlock.unlock();
        wlock.lock();
        fluidNBTList = _fluidIdentifierTagCache.get(fluidID);
        if (fluidNBTList != null && (unknownFluid = (FluidIdentifier)fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            wlock.unlock();
            return unknownFluid;
        }
        fluidNBTList = _fluidIdentifierTagCache.computeIfAbsent(fluidID, k -> new HashMap(16, 0.5f));
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound(tag);
        int id = FluidIdentifier.getUnusedId();
        FluidIdentifier unknownFluid2 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((Fluid)fluid), finaltag, id);
        fluidNBTList.put(finaltag, unknownFluid2);
        _fluidIdentifierIdCache.put(id, unknownFluid2);
        wlock.unlock();
        return unknownFluid2;
    }

    private static FluidIdentifier getFluidIdentifierWithoutTag(Fluid fluid, String fluidID, FluidIdentifier proposal) {
        if (proposal != null && proposal.fluidID.equals(fluidID) && proposal.tag == null) {
            return proposal;
        }
        rlock.lock();
        FluidIdentifier unknownFluid = _fluidIdentifierCache.get(fluidID);
        if (unknownFluid != null) {
            rlock.unlock();
            return unknownFluid;
        }
        rlock.unlock();
        wlock.lock();
        unknownFluid = _fluidIdentifierCache.get(fluidID);
        if (unknownFluid != null) {
            wlock.unlock();
            return unknownFluid;
        }
        int id = FluidIdentifier.getUnusedId();
        FluidIdentifier unknownFluid2 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((Fluid)fluid), null, id);
        _fluidIdentifierCache.put(fluidID, unknownFluid2);
        _fluidIdentifierIdCache.put(id, unknownFluid2);
        wlock.unlock();
        return unknownFluid2;
    }

    public static FluidIdentifier get(FluidStack stack) {
        FluidIdentifier ident;
        FluidStackAddInfo info;
        if (stack == null) {
            return null;
        }
        FluidIdentifier proposal = null;
        IAddInfoProvider prov = null;
        if (stack instanceof IAddInfoProvider && (info = (prov = (IAddInfoProvider)stack).getLogisticsPipesAddInfo(FluidStackAddInfo.class)) != null) {
            proposal = info.fluid;
        }
        if (proposal != (ident = FluidIdentifier.get(stack.getFluid(), stack.tag, proposal)) && stack.tag == null && prov != null) {
            prov.setLogisticsPipesAddInfo(new FluidStackAddInfo(ident));
        }
        return ident;
    }

    public static FluidIdentifier get(ItemIdentifier stack) {
        return FluidIdentifier.get(stack.makeStack(1));
    }

    public static FluidIdentifier get(ItemStack stack) {
        return FluidIdentifier.get(ItemIdentifierStack.getFromStack(stack));
    }

    public static FluidIdentifier get(ItemIdentifierStack stack) {
        IFluidHandlerItem capability;
        ItemStack itemStack;
        FluidStack f = null;
        FluidIdentifierStack fstack = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(stack);
        if (fstack != null) {
            f = fstack.makeFluidStack();
        }
        if (f == null && (itemStack = stack.unsafeMakeNormalStack()).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (capability = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            f = Arrays.stream(capability.getTankProperties()).map(IFluidTankProperties::getContents).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (f == null) {
            f = FluidUtil.getFluidContained((ItemStack)stack.unsafeMakeNormalStack());
        }
        if (f == null) {
            return null;
        }
        return FluidIdentifier.get(f);
    }

    private static FluidIdentifier get(Fluid fluid) {
        return FluidIdentifier.get(fluid, null, null);
    }

    private static int getUnusedId() {
        int id = new Random().nextInt();
        while (FluidIdentifier.isIdUsed(id)) {
            id = new Random().nextInt();
        }
        return id;
    }

    private static boolean isIdUsed(int id) {
        return _fluidIdentifierIdCache.containsKey(id);
    }

    public String getName() {
        return this.name;
    }

    public FluidStack makeFluidStack(int amount) {
        return new FluidStack(this.getFluid(), amount, (NBTTagCompound)this.tag);
    }

    public FluidIdentifierStack makeFluidIdentifierStack(int amount) {
        return new FluidIdentifierStack(this, amount);
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.fluidID);
    }

    public int getFreeSpaceInsideTank(IFluidTank tank) {
        FluidStack liquid = tank.getFluid();
        if (liquid == null || liquid.getFluid() == null) {
            return tank.getCapacity();
        }
        if (FluidIdentifier.get(liquid).equals(this)) {
            return tank.getCapacity() - liquid.amount;
        }
        return 0;
    }

    public static void initFromForge(boolean flag) {
        if (init) {
            return;
        }
        Map fluids = FluidRegistry.getRegisteredFluids();
        fluids.values().forEach(FluidIdentifier::get);
        if (flag) {
            init = true;
        }
    }

    public String toString() {
        String t = this.tag != null ? this.tag.toString() : "null";
        return this.name + "/" + this.fluidID + ":" + t;
    }

    public FluidIdentifier next() {
        rlock.lock();
        boolean takeNext = false;
        for (FluidIdentifier i : _fluidIdentifierCache.values()) {
            if (takeNext && i != null) {
                rlock.unlock();
                return i;
            }
            if (!this.equals(i)) continue;
            takeNext = true;
        }
        rlock.unlock();
        return null;
    }

    public FluidIdentifier prev() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache.values()) {
            if (this.equals(i)) {
                rlock.unlock();
                return last;
            }
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public static FluidIdentifier first() {
        rlock.lock();
        for (FluidIdentifier i : _fluidIdentifierCache.values()) {
            if (i == null) continue;
            rlock.unlock();
            return i;
        }
        rlock.unlock();
        return null;
    }

    public static FluidIdentifier last() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache.values()) {
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public static Collection<FluidIdentifier> all() {
        rlock.lock();
        Collection<FluidIdentifier> list = Collections.unmodifiableCollection(_fluidIdentifierCache.values());
        rlock.unlock();
        return list;
    }

    public ItemIdentifier getItemIdentifier() {
        return SimpleServiceLocator.logisticsFluidManager.getFluidContainer(this.makeFluidIdentifierStack(1)).getItem();
    }

    @Override
    public void setCCType(Object type) {
        this.ccObject = type;
    }

    @Override
    public Object getCCType() {
        return this.ccObject;
    }

    private static class FluidAddInfo
    implements IAddInfo {
        private final FluidIdentifier fluid;

        @ConstructorProperties(value={"fluid"})
        public FluidAddInfo(FluidIdentifier fluid) {
            this.fluid = fluid;
        }
    }

    private static class FluidStackAddInfo
    implements IAddInfo {
        private final FluidIdentifier fluid;

        @ConstructorProperties(value={"fluid"})
        public FluidStackAddInfo(FluidIdentifier fluid) {
            this.fluid = fluid;
        }
    }
}

