/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil
implements IInventoryUtil,
ISpecialInsertion {
    protected final IItemHandler _inventory;
    private final boolean _hideOnePerStack;
    private final boolean _hideOne;
    private final int _cropStart;
    private final int _cropEnd;

    public InventoryUtil(IItemHandler inventory, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._inventory = inventory;
        this._hideOnePerStack = hideOnePerStack;
        this._hideOne = hideOne;
        this._cropStart = cropStart;
        this._cropEnd = cropEnd;
    }

    @Override
    public int itemCount(ItemIdentifier item) {
        int count = 0;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.getSlots() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemIdentifier.get(stack).equals(item)) continue;
            if (first) {
                count = stack.func_190916_E() - (this._hideOne || this._hideOnePerStack ? 1 : 0);
                first = false;
                continue;
            }
            count += stack.func_190916_E() - (this._hideOnePerStack ? 1 : 0);
        }
        return count;
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        LinkedHashMap<ItemIdentifier, Integer> items = new LinkedHashMap<ItemIdentifier, Integer>();
        for (int i = this._cropStart; i < this._inventory.getSlots() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.func_190916_E() - (this._hideOnePerStack ? 1 : 0);
            Integer currentSize = (Integer)items.get(itemId);
            if (currentSize == null) {
                items.put(itemId, stackSize - (this._hideOne ? 1 : 0));
                continue;
            }
            items.put(itemId, currentSize + stackSize);
        }
        return items;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> items = new TreeSet<ItemIdentifier>();
        for (int i = this._cropStart; i < this._inventory.getSlots() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.add(ItemIdentifier.get(stack));
        }
        return items;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        return this.getMultipleItems(item, 1);
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(ItemIdentifier item, int count) {
        if (this.itemCount(item) < count) {
            return ItemStack.field_190927_a;
        }
        ItemStack outputStack = ItemStack.field_190927_a;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.getSlots() - this._cropEnd && count > 0; ++i) {
            ItemStack stack = this._inventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_190916_E() == 1 && this._hideOnePerStack || !ItemIdentifier.get(stack).equals(item)) continue;
            int itemsToSplit = Math.min(count, stack.func_190916_E() - (first && this._hideOne || this._hideOnePerStack ? 1 : 0));
            first = false;
            if (itemsToSplit == 0) continue;
            ItemStack removed = this._inventory.extractItem(i, itemsToSplit, false);
            if (outputStack.func_190926_b()) {
                outputStack = removed;
            } else {
                outputStack.func_190920_e(outputStack.func_190916_E() + removed.func_190916_E());
            }
            count -= removed.func_190916_E();
        }
        return outputStack;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.getSlots(); ++i) {
            ItemStack stack = this._inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemIdentifier.get(stack).getUndamaged().equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, Integer.MAX_VALUE);
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        ItemStack leftover;
        if (this._inventory.getSlots() == 1 && this._inventory.getSlotLimit(0) == Integer.MAX_VALUE) {
            ItemStack content = this._inventory.extractItem(0, Integer.MAX_VALUE, true);
            if (content.func_190926_b()) {
                return Integer.MAX_VALUE;
            }
            return Integer.MAX_VALUE - content.func_190916_E();
        }
        int totalRoom = 0;
        for (int i = 0; i < this._inventory.getSlots() && count > totalRoom; totalRoom += count - leftover.func_190916_E(), ++i) {
            leftover = this._inventory.insertItem(i, item.unsafeMakeNormalStack(count), true);
        }
        return totalRoom;
    }

    @Override
    public int getSizeInventory() {
        return this._inventory.getSlots();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        return this._inventory.getStackInSlot(i);
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        return this._inventory.extractItem(i, j, false);
    }

    @Override
    public int addToSlot(ItemStack stack, int slot) {
        int wanted = stack.func_190916_E();
        ItemStack rest = this._inventory.insertItem(slot, stack, true);
        return wanted - rest.func_190916_E();
    }
}

