/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import network.rs485.logisticspipes.world.IntegerCoordinates;

public class OrientationsUtil {
    public static EnumFacing getOrientationOfTilewithTile(TileEntity pipeTile, TileEntity tileTile) {
        IntegerCoordinates pipe = new IntegerCoordinates(pipeTile.func_174877_v());
        IntegerCoordinates tile = new IntegerCoordinates(tileTile.func_174877_v());
        if (pipe.getZCoord() == tile.getZCoord() && pipe.getYCoord() == tile.getYCoord()) {
            if (pipe.getXCoord() < tile.getXCoord()) {
                return EnumFacing.EAST;
            }
            if (pipe.getXCoord() > tile.getXCoord()) {
                return EnumFacing.WEST;
            }
        }
        if (pipe.getXCoord() == tile.getXCoord() && pipe.getZCoord() == tile.getZCoord()) {
            if (pipe.getYCoord() < tile.getYCoord()) {
                return EnumFacing.UP;
            }
            if (pipe.getYCoord() > tile.getYCoord()) {
                return EnumFacing.DOWN;
            }
        }
        if (pipe.getXCoord() == tile.getXCoord() && pipe.getYCoord() == tile.getYCoord()) {
            if (pipe.getZCoord() < tile.getZCoord()) {
                return EnumFacing.SOUTH;
            }
            if (pipe.getZCoord() > tile.getZCoord()) {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public static TileEntity getTileNextToThis(TileEntity tile, EnumFacing dir) {
        int x = tile.func_174877_v().func_177958_n();
        int y = tile.func_174877_v().func_177956_o();
        int z = tile.func_174877_v().func_177952_p();
        switch (dir) {
            case UP: {
                ++y;
                break;
            }
            case DOWN: {
                --y;
                break;
            }
            case SOUTH: {
                ++z;
                break;
            }
            case NORTH: {
                --z;
                break;
            }
            case EAST: {
                ++x;
                break;
            }
            case WEST: {
                --x;
                break;
            }
        }
        return tile.func_145831_w().func_175625_s(new BlockPos(x, y, z));
    }

    public static boolean isSide(EnumFacing ori) {
        return ori == EnumFacing.EAST || ori == EnumFacing.WEST || ori == EnumFacing.SOUTH || ori == EnumFacing.NORTH;
    }
}

