/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.LPItems;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemStackRenderer {
    private RenderManager renderManager;
    private RenderItem renderItem;
    private TextureManager texManager;
    private FontRenderer fontRenderer;
    private RenderEntityItem itemEntityRenderer;
    @Nonnull
    private ItemStack itemstack = ItemStack.field_190927_a;
    private ItemIdentifierStack itemIdentStack;
    private int posX;
    private int posY;
    private float zLevel;
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private DisplayAmount displayAmount;
    private boolean renderEffects;
    private boolean ignoreDepth;
    private boolean renderInColor;
    private EntityItem entityitem;
    private World world;
    private float partialTickTime;

    public ItemStackRenderer(int posX, int posY, float zLevel, boolean renderEffects, boolean ignoreDepth) {
        this.posX = posX;
        this.posY = posY;
        this.zLevel = zLevel;
        this.renderEffects = renderEffects;
        this.ignoreDepth = ignoreDepth;
        this.renderManager = Minecraft.func_71410_x().func_175598_ae();
        this.fontRenderer = this.renderManager.func_78716_a();
        this.world = this.renderManager.field_78722_g;
        this.texManager = this.renderManager.field_78724_e;
        if (this.texManager == null) {
            this.texManager = Minecraft.func_71410_x().func_110434_K();
        }
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        this.itemEntityRenderer = new RenderEntityItem(this.renderManager, this.renderItem);
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount) {
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, zLevel, displayAmount, true, false);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount, boolean renderEffect, boolean ignoreDepth) {
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer(0, 0, zLevel, renderEffect, ignoreDepth);
        itemStackRenderer.setDisplayAmount(displayAmount);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, itemStackRenderer);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, ItemStackRenderer itemStackRenderer) {
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack identifierStack : _allItems) {
            if (identifierStack == null) {
                if (++column >= columns) {
                    ++row;
                    column = 0;
                }
                ++ppi;
                continue;
            }
            ItemIdentifier item = identifierStack.getItem();
            if (IItemSearch2 != null && !IItemSearch2.itemSearched(item) || ++ppi <= items * page || ppi > items * (page + 1)) continue;
            ItemStack itemstack = identifierStack.unsafeMakeNormalStack();
            int x = left + xSize * column;
            int y = top + ySize * row + 1;
            if (!itemstack.func_190926_b()) {
                itemStackRenderer.setItemstack(itemstack).setPosX(x).setPosY(y);
                itemStackRenderer.renderInGui();
            }
            if (++column < columns) continue;
            ++row;
            column = 0;
        }
    }

    public void renderInGui() {
        assert (this.displayAmount != null);
        assert (this.renderItem != null);
        assert (this.texManager != null);
        assert (this.fontRenderer != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179133_A();
        GlStateManager.func_179152_a((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179152_a((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
        if (this.ignoreDepth) {
            GlStateManager.func_179097_i();
        } else {
            GlStateManager.func_179126_j();
        }
        this.renderItem.field_77023_b += this.zLevel;
        if (this.itemIdentStack != null) {
            this.itemstack = this.itemIdentStack.getStackSize() < 1 ? this.itemIdentStack.getItem().unsafeMakeNormalStack(1) : this.itemIdentStack.unsafeMakeNormalStack();
        }
        IBakedModel bakedmodel = this.renderItem.func_184393_a(this.itemstack, null, (EntityLivingBase)(this.renderEffects ? Minecraft.func_71410_x().field_71439_g : null));
        GlStateManager.func_179094_E();
        this.texManager.func_110577_a(TextureMap.field_110575_b);
        this.texManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupGuiTransform(this.posX, this.posY, bakedmodel.func_177556_c());
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.renderItem.func_180454_a(this.itemstack, bakedmodel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        this.texManager.func_110577_a(TextureMap.field_110575_b);
        this.texManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        this.renderItem.field_77023_b -= this.zLevel;
        RenderHelper.func_74518_a();
        if (this.ignoreDepth) {
            GlStateManager.func_179097_i();
        } else {
            GlStateManager.func_179126_j();
        }
        GuiGraphics.drawDurabilityBar(this.itemstack, this.posX, this.posY, this.zLevel + 20.0f);
        if (this.displayAmount != DisplayAmount.NEVER) {
            if (this.ignoreDepth) {
                GlStateManager.func_179097_i();
            } else {
                GlStateManager.func_179126_j();
            }
            FontRenderer specialFontRenderer = this.itemstack.func_77973_b().getFontRenderer(this.itemstack);
            if (specialFontRenderer != null) {
                this.fontRenderer = specialFontRenderer;
            }
            GlStateManager.func_179140_f();
            String amountString = StringUtils.getFormatedStackSize(this.itemIdentStack != null ? (long)this.itemIdentStack.getStackSize() : (long)this.itemstack.func_190916_E(), this.displayAmount == DisplayAmount.ALWAYS);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(this.zLevel + 130.0f));
            SimpleGraphics.drawStringWithTranslatedShadow(this.fontRenderer, amountString, this.posX + 17 - this.fontRenderer.func_78256_a(amountString), this.posY + 9, Color.getValue(Color.WHITE));
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(this.zLevel + 130.0f)));
        }
        GlStateManager.func_179121_F();
    }

    private void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + this.renderItem.field_77023_b));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    public void renderInWorld() {
        Item item;
        assert (this.renderManager != null);
        assert (this.renderItem != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        if (this.entityitem == null || !ItemStack.func_77989_b((ItemStack)this.entityitem.func_92059_d(), (ItemStack)this.itemstack)) {
            if (this.itemstack.func_190926_b()) {
                throw new RuntimeException("No EntityItem and no ItemStack, I do not know what to render!");
            }
            if (this.world == null) {
                throw new NullPointerException("World object is null");
            }
            this.entityitem = new EntityItem(this.world, 0.0, 0.0, 0.0, this.itemstack);
            this.entityitem.func_92059_d().func_190920_e(1);
            this.entityitem.field_70290_d = 0.0f;
        }
        if ((item = this.itemstack.func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            if (block instanceof BlockPane) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (item == LPItems.requestTable) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        this.itemEntityRenderer.func_76986_a(this.entityitem, (double)this.posX, (double)this.posY, (double)this.zLevel, 0.0f, this.partialTickTime);
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public RenderItem getRenderItem() {
        return this.renderItem;
    }

    public TextureManager getTexManager() {
        return this.texManager;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public RenderEntityItem getItemEntityRenderer() {
        return this.itemEntityRenderer;
    }

    @Nonnull
    public ItemStack getItemstack() {
        return this.itemstack;
    }

    public ItemIdentifierStack getItemIdentStack() {
        return this.itemIdentStack;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public DisplayAmount getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean isRenderEffects() {
        return this.renderEffects;
    }

    public boolean isIgnoreDepth() {
        return this.ignoreDepth;
    }

    public boolean isRenderInColor() {
        return this.renderInColor;
    }

    public EntityItem getEntityitem() {
        return this.entityitem;
    }

    public World getWorld() {
        return this.world;
    }

    public float getPartialTickTime() {
        return this.partialTickTime;
    }

    public ItemStackRenderer setRenderManager(RenderManager renderManager) {
        this.renderManager = renderManager;
        return this;
    }

    public ItemStackRenderer setRenderItem(RenderItem renderItem) {
        this.renderItem = renderItem;
        return this;
    }

    public ItemStackRenderer setTexManager(TextureManager texManager) {
        this.texManager = texManager;
        return this;
    }

    public ItemStackRenderer setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        return this;
    }

    public ItemStackRenderer setItemEntityRenderer(RenderEntityItem itemEntityRenderer) {
        this.itemEntityRenderer = itemEntityRenderer;
        return this;
    }

    public ItemStackRenderer setItemstack(@Nonnull ItemStack itemstack) {
        if (itemstack == null) {
            throw new NullPointerException("itemstack");
        }
        this.itemstack = itemstack;
        return this;
    }

    public ItemStackRenderer setItemIdentStack(ItemIdentifierStack itemIdentStack) {
        this.itemIdentStack = itemIdentStack;
        return this;
    }

    public ItemStackRenderer setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public ItemStackRenderer setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public ItemStackRenderer setZLevel(float zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public ItemStackRenderer setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public ItemStackRenderer setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public ItemStackRenderer setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
        return this;
    }

    public ItemStackRenderer setDisplayAmount(DisplayAmount displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public ItemStackRenderer setRenderEffects(boolean renderEffects) {
        this.renderEffects = renderEffects;
        return this;
    }

    public ItemStackRenderer setIgnoreDepth(boolean ignoreDepth) {
        this.ignoreDepth = ignoreDepth;
        return this;
    }

    public ItemStackRenderer setRenderInColor(boolean renderInColor) {
        this.renderInColor = renderInColor;
        return this;
    }

    public ItemStackRenderer setEntityitem(EntityItem entityitem) {
        this.entityitem = entityitem;
        return this;
    }

    public ItemStackRenderer setWorld(World world) {
        this.world = world;
        return this;
    }

    public ItemStackRenderer setPartialTickTime(float partialTickTime) {
        this.partialTickTime = partialTickTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackRenderer)) {
            return false;
        }
        ItemStackRenderer other = (ItemStackRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RenderManager this$renderManager = this.getRenderManager();
        RenderManager other$renderManager = other.getRenderManager();
        if (this$renderManager == null ? other$renderManager != null : !this$renderManager.equals(other$renderManager)) {
            return false;
        }
        RenderItem this$renderItem = this.getRenderItem();
        RenderItem other$renderItem = other.getRenderItem();
        if (this$renderItem == null ? other$renderItem != null : !this$renderItem.equals(other$renderItem)) {
            return false;
        }
        TextureManager this$texManager = this.getTexManager();
        TextureManager other$texManager = other.getTexManager();
        if (this$texManager == null ? other$texManager != null : !this$texManager.equals(other$texManager)) {
            return false;
        }
        FontRenderer this$fontRenderer = this.getFontRenderer();
        FontRenderer other$fontRenderer = other.getFontRenderer();
        if (this$fontRenderer == null ? other$fontRenderer != null : !this$fontRenderer.equals(other$fontRenderer)) {
            return false;
        }
        RenderEntityItem this$itemEntityRenderer = this.getItemEntityRenderer();
        RenderEntityItem other$itemEntityRenderer = other.getItemEntityRenderer();
        if (this$itemEntityRenderer == null ? other$itemEntityRenderer != null : !this$itemEntityRenderer.equals(other$itemEntityRenderer)) {
            return false;
        }
        ItemStack this$itemstack = this.getItemstack();
        ItemStack other$itemstack = other.getItemstack();
        if (this$itemstack == null ? other$itemstack != null : !this$itemstack.equals(other$itemstack)) {
            return false;
        }
        ItemIdentifierStack this$itemIdentStack = this.getItemIdentStack();
        ItemIdentifierStack other$itemIdentStack = other.getItemIdentStack();
        if (this$itemIdentStack == null ? other$itemIdentStack != null : !((Object)this$itemIdentStack).equals(other$itemIdentStack)) {
            return false;
        }
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (Float.compare(this.getZLevel(), other.getZLevel()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleX(), other.getScaleX()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleY(), other.getScaleY()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleZ(), other.getScaleZ()) != 0) {
            return false;
        }
        DisplayAmount this$displayAmount = this.getDisplayAmount();
        DisplayAmount other$displayAmount = other.getDisplayAmount();
        if (this$displayAmount == null ? other$displayAmount != null : !((Object)((Object)this$displayAmount)).equals((Object)other$displayAmount)) {
            return false;
        }
        if (this.isRenderEffects() != other.isRenderEffects()) {
            return false;
        }
        if (this.isIgnoreDepth() != other.isIgnoreDepth()) {
            return false;
        }
        if (this.isRenderInColor() != other.isRenderInColor()) {
            return false;
        }
        EntityItem this$entityitem = this.getEntityitem();
        EntityItem other$entityitem = other.getEntityitem();
        if (this$entityitem == null ? other$entityitem != null : !this$entityitem.equals(other$entityitem)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        return Float.compare(this.getPartialTickTime(), other.getPartialTickTime()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStackRenderer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RenderManager $renderManager = this.getRenderManager();
        result = result * 59 + ($renderManager == null ? 43 : $renderManager.hashCode());
        RenderItem $renderItem = this.getRenderItem();
        result = result * 59 + ($renderItem == null ? 43 : $renderItem.hashCode());
        TextureManager $texManager = this.getTexManager();
        result = result * 59 + ($texManager == null ? 43 : $texManager.hashCode());
        FontRenderer $fontRenderer = this.getFontRenderer();
        result = result * 59 + ($fontRenderer == null ? 43 : $fontRenderer.hashCode());
        RenderEntityItem $itemEntityRenderer = this.getItemEntityRenderer();
        result = result * 59 + ($itemEntityRenderer == null ? 43 : $itemEntityRenderer.hashCode());
        ItemStack $itemstack = this.getItemstack();
        result = result * 59 + ($itemstack == null ? 43 : $itemstack.hashCode());
        ItemIdentifierStack $itemIdentStack = this.getItemIdentStack();
        result = result * 59 + ($itemIdentStack == null ? 43 : ((Object)$itemIdentStack).hashCode());
        result = result * 59 + this.getPosX();
        result = result * 59 + this.getPosY();
        result = result * 59 + Float.floatToIntBits(this.getZLevel());
        result = result * 59 + Float.floatToIntBits(this.getScaleX());
        result = result * 59 + Float.floatToIntBits(this.getScaleY());
        result = result * 59 + Float.floatToIntBits(this.getScaleZ());
        DisplayAmount $displayAmount = this.getDisplayAmount();
        result = result * 59 + ($displayAmount == null ? 43 : ((Object)((Object)$displayAmount)).hashCode());
        result = result * 59 + (this.isRenderEffects() ? 79 : 97);
        result = result * 59 + (this.isIgnoreDepth() ? 79 : 97);
        result = result * 59 + (this.isRenderInColor() ? 79 : 97);
        EntityItem $entityitem = this.getEntityitem();
        result = result * 59 + ($entityitem == null ? 43 : $entityitem.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getPartialTickTime());
        return result;
    }

    public String toString() {
        return "ItemStackRenderer(renderManager=" + this.getRenderManager() + ", renderItem=" + this.getRenderItem() + ", texManager=" + this.getTexManager() + ", fontRenderer=" + this.getFontRenderer() + ", itemEntityRenderer=" + this.getItemEntityRenderer() + ", itemstack=" + this.getItemstack() + ", itemIdentStack=" + this.getItemIdentStack() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", zLevel=" + this.getZLevel() + ", scaleX=" + this.getScaleX() + ", scaleY=" + this.getScaleY() + ", scaleZ=" + this.getScaleZ() + ", displayAmount=" + (Object)((Object)this.getDisplayAmount()) + ", renderEffects=" + this.isRenderEffects() + ", ignoreDepth=" + this.isIgnoreDepth() + ", renderInColor=" + this.isRenderInColor() + ", entityitem=" + this.getEntityitem() + ", world=" + this.getWorld() + ", partialTickTime=" + this.getPartialTickTime() + ")";
    }

    public static enum DisplayAmount {
        HIDE_ONE,
        ALWAYS,
        NEVER;

    }
}

