/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.awt.Rectangle;
import logisticspipes.utils.math.Matrix4d;
import logisticspipes.utils.math.Vector3d;
import logisticspipes.utils.math.Vector4d;

public class VecmathUtil {
    public static Vector3d clamp(Vector3d v, double min, double max) {
        v.x = VecmathUtil.clamp(v.x, min, max);
        v.y = VecmathUtil.clamp(v.y, min, max);
        v.z = VecmathUtil.clamp(v.z, min, max);
        return v;
    }

    public static double clamp(double val, double min, double max) {
        return val < min ? min : Math.min(val, max);
    }

    public static int clamp(int val, int min, int max) {
        return val < min ? min : Math.min(val, max);
    }

    public static Matrix4d createProjectionMatrixAsPerspective(double fovDegrees, double near, double far, int viewportWidth, int viewportHeight) {
        double aspect = (double)viewportWidth / (double)viewportHeight;
        double theta = Math.toRadians(fovDegrees) / 2.0;
        double f = Math.cos(theta) / Math.sin(theta);
        double a = (far + near) / (near - far);
        double b = 2.0 * far * near / (near - far);
        return new Matrix4d(f / aspect, 0.0, 0.0, 0.0, 0.0, f, 0.0, 0.0, 0.0, 0.0, a, b, 0.0, 0.0, -1.0, 0.0);
    }

    public static Matrix4d createMatrixAsLookAt(Vector3d eyePos, Vector3d lookAtPos, Vector3d upVec) {
        Vector3d eye = new Vector3d(eyePos);
        Vector3d lookAt = new Vector3d(lookAtPos);
        Vector3d up = new Vector3d(upVec);
        Vector3d forwardVec = new Vector3d(lookAt);
        forwardVec.sub(eye);
        forwardVec.makeVectorLength(1.0);
        Vector3d sideVec = new Vector3d();
        sideVec.cross(forwardVec, up);
        sideVec.makeVectorLength(1.0);
        Vector3d upVed = new Vector3d();
        upVed.cross(sideVec, forwardVec);
        upVed.makeVectorLength(1.0);
        Matrix4d mat = new Matrix4d(sideVec.x, sideVec.y, sideVec.z, 0.0, upVed.x, upVed.y, upVed.z, 0.0, -forwardVec.x, -forwardVec.y, -forwardVec.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        eye.negate();
        mat.transformNormal(eye);
        mat.setTranslation(eye);
        return mat;
    }

    public static void computeRayForPixel(Rectangle vp, Matrix4d ipm, Matrix4d ivm, int x, int y, Vector3d eyeOut, Vector3d normalOut) {
        ivm.getTranslation(eyeOut);
        Matrix4d vpm = new Matrix4d();
        vpm.mul(ivm, ipm);
        double screenX = ((double)x - vp.getX()) / vp.getWidth();
        double screenY = ((double)y - vp.getY()) / vp.getHeight();
        screenX = screenX * 2.0 - 1.0;
        screenY = screenY * 2.0 - 1.0;
        Vector4d tmp = new Vector4d();
        tmp.x = screenX;
        tmp.y = screenY;
        tmp.z = -1.0;
        tmp.w = 1.0;
        vpm.transform(tmp);
        double w = tmp.w;
        Vector3d nearXYZ = new Vector3d(tmp.x / w, tmp.y / w, tmp.z / w);
        tmp.x = screenX;
        tmp.y = screenY;
        tmp.z = 1.0;
        tmp.w = 1.0;
        vpm.transform(tmp);
        w = tmp.w;
        Vector3d farXYZ = new Vector3d(tmp.x / w, tmp.y / w, tmp.z / w);
        normalOut.set(farXYZ);
        normalOut.sub(nearXYZ);
        normalOut.makeVectorLength(1.0);
    }
}

