/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.dwmh.commands;

import com.noobanidus.dwmh.init.ItemRegistry;
import com.noobanidus.dwmh.items.ItemOcarina;
import com.noobanidus.dwmh.util.EntityTracking;
import com.noobanidus.dwmh.world.DataHelper;
import com.noobanidus.dwmh.world.EntityData;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandOcarina
extends CommandBase {
    public String func_71517_b() {
        return "ocarina";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ocarina clear | /ocarina sync";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
                EntityData data = DataHelper.getTrackingData();
                List<UUID> owned = data.ownerToEntities.get(player.func_110124_au());
                if (owned == null || owned.isEmpty()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("No entities to clear."));
                } else {
                    for (UUID entity : owned) {
                        if (!data.savedEntities.containsKey(entity)) continue;
                        String name = data.entityToName.get(entity);
                        if (name == null || name.isEmpty()) {
                            name = "Unknown name";
                        }
                        player.func_145747_a((ITextComponent)new TextComponentString("One or more entities (" + name + ") are saved from unloaded chunks or death! Summon them before continuing."));
                        return;
                    }
                    for (UUID entity : owned) {
                        data.entityToOwner.remove(entity);
                        data.savedEntities.remove(entity);
                        data.restoredEntities.remove(entity);
                        data.trackedEntities.remove(entity);
                        data.entityToResourceLocation.remove(entity);
                        data.entityToName.remove(entity);
                    }
                    data.ownerToEntities.remove(player.func_110124_au());
                    EntityTracking.save();
                    this.trySyncHand(player);
                    player.func_145747_a((ITextComponent)new TextComponentString("Entities cleared!"));
                }
            } else if (args.length == 1 && args[0].equalsIgnoreCase("sync")) {
                this.trySyncHand(player);
                player.func_145747_a((ITextComponent)new TextComponentString("Ocarinas in hand and inventory synced."));
            }
        }
    }

    public void trySyncHand(EntityPlayerMP player) {
        IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).func_77973_b() != ItemRegistry.OCARINA) continue;
            ItemStack ocarina = inventory.extractItem(i, 1, false);
            ItemOcarina.updateOcarinaNBT(ocarina, (EntityPlayer)player);
            inventory.insertItem(i, ocarina, false);
        }
        ItemStack offHand = player.func_184592_cb();
        if (offHand.func_77973_b() == ItemRegistry.OCARINA) {
            ItemOcarina.updateOcarinaNBT(offHand, (EntityPlayer)player);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }
}

