/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.dwmh.events;

import com.noobanidus.dwmh.init.ItemRegistry;
import com.noobanidus.dwmh.items.ItemOcarina;
import com.noobanidus.dwmh.util.EntityTracking;
import com.noobanidus.dwmh.util.Util;
import com.noobanidus.dwmh.world.EntityData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class EventHandler {
    public static boolean isSpawning = false;

    @SubscribeEvent
    public static void handleItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getAllMappings()) {
            if (!m.key.func_110624_b().equals("dwmh") || !m.key.func_110623_a().equals("whistle")) continue;
            m.remap((IForgeRegistryEntry)ItemRegistry.OCARINA);
        }
    }

    @SubscribeEvent
    public static void handleRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() == ItemRegistry.OCARINA && player.func_70093_af()) {
            if (!player.field_70170_p.field_72995_K) {
                ItemRegistry.OCARINA.rightClickEntity(player, event.getTarget(), stack);
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleChunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Chunk chunk = event.getChunk();
            EntityData data = EntityTracking.getData();
            if (data == null) {
                return;
            }
            for (ClassInheritanceMultiMap entityList : chunk.func_177429_s()) {
                for (Entity entity : entityList) {
                    if (!data.trackedEntities.contains(entity.func_110124_au())) continue;
                    entity.func_184226_ay();
                    data.storedEntities.add(entity.func_110124_au());
                    NBTTagCompound savedEntity = entity.func_189511_e(new NBTTagCompound());
                    data.savedEntities.put(entity.func_110124_au(), savedEntity);
                    data.entityToResourceLocation.put(entity.func_110124_au(), EntityList.func_191301_a((Entity)entity));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleEntityJoin(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            EntityData data = EntityTracking.getData();
            if (data == null) {
                return;
            }
            if (data.restoredEntities.isEmpty() && data.storedEntities.isEmpty()) {
                return;
            }
            if (data.savedEntities.isEmpty()) {
                return;
            }
            Entity entity = event.getEntity();
            if (!data.savedEntities.containsKey(entity.func_110124_au())) {
                return;
            }
            if (data.restoredEntities.contains(entity.func_110124_au()) && !isSpawning) {
                event.setCanceled(true);
                data.restoredEntities.remove(entity.func_110124_au());
            } else if (data.storedEntities.contains(entity.func_110124_au())) {
                data.storedEntities.remove(entity.func_110124_au());
                data.savedEntities.remove(entity.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public static void handleEntityDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            EntityData data = EntityTracking.getData();
            if (data == null) {
                return;
            }
            if (data.trackedEntities.contains(entity.func_110124_au())) {
                EntityPlayer player;
                entity.field_70128_L = false;
                entity.func_70606_j(entity.func_110138_aP());
                entity.func_184226_ay();
                NBTTagCompound savedEntity = entity.func_189511_e(new NBTTagCompound());
                entity.field_70128_L = true;
                data.savedEntities.put(entity.func_110124_au(), savedEntity);
                data.entityToResourceLocation.put(entity.func_110124_au(), EntityList.func_191301_a((Entity)entity));
                UUID owner = data.entityToOwner.get(entity.func_110124_au());
                if (owner != null && (player = Util.resolvePlayer(owner)) != null) {
                    player.func_146105_b(new TextComponentTranslation("dwmh.status.saved", new Object[]{Util.resolveName(entity.func_110124_au())}).func_150255_a(Util.DEFAULT_STYLE), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void handlePlayerCraft(PlayerEvent.ItemCraftedEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.crafting.func_77973_b() == ItemRegistry.OCARINA) {
            ItemOcarina.updateOcarinaNBT(event.crafting, event.player);
        }
    }

    @SubscribeEvent
    public static void handleEntityDrops(LivingDropsEvent event) {
        EventHandler.handleDrops((LivingEvent)event);
    }

    @SubscribeEvent
    public static void handleEntityXP(LivingExperienceDropEvent event) {
        EventHandler.handleDrops((LivingEvent)event);
    }

    private static void handleDrops(LivingEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            EntityData data = EntityTracking.getData();
            if (data == null) {
                return;
            }
            if (data.trackedEntities.contains(entity.func_110124_au())) {
                event.setCanceled(true);
            }
        }
    }
}

