/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.dwmh.items;

import com.noobanidus.dwmh.ConfigHandler;
import com.noobanidus.dwmh.init.SoundRegistry;
import com.noobanidus.dwmh.util.Eligibility;
import com.noobanidus.dwmh.util.EntityTracking;
import com.noobanidus.dwmh.util.Util;
import com.noobanidus.dwmh.world.DataHelper;
import com.noobanidus.dwmh.world.EntityData;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOcarina
extends Item {
    public static long DELAY = 2000L;
    private static Object2LongOpenHashMap<EntityPlayer> lastPlayedMap = new Object2LongOpenHashMap();

    private static boolean canPlay(EntityPlayer player) {
        long last = lastPlayedMap.getLong((Object)player);
        return System.currentTimeMillis() - last >= DELAY || last == 0L;
    }

    private static void playSound(EntityPlayer player, boolean minor) {
        if (!ItemOcarina.canPlay(player)) {
            return;
        }
        lastPlayedMap.put((Object)player, System.currentTimeMillis());
        SoundEvent sound = minor ? SoundRegistry.getRandomMinorWhistle() : SoundRegistry.getRandomWhistle();
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private static void playSound(EntityPlayer player) {
        ItemOcarina.playSound(player, false);
    }

    public ItemOcarina() {
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void rightClickEntity(EntityPlayer playerIn, Entity target, ItemStack stack) {
        if (Eligibility.eligibleToBeTagged(playerIn, target)) {
            UUID owner = EntityTracking.getOwnerForEntity(target);
            NBTTagCompound tag = Util.getOrCreateTagCompound(stack);
            if (owner == null) {
                boolean result = EntityTracking.setOwnerForEntity(playerIn, target);
                if (result) {
                    tag.func_186854_a("target", target.func_110124_au());
                    playerIn.func_146105_b(new TextComponentTranslation("dwmh.status.success_setting_owner", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                    ItemOcarina.playSound(playerIn);
                } else {
                    int count = EntityTracking.entityCount(playerIn);
                    if (count != ConfigHandler.entityMaximum) {
                        playerIn.func_146105_b(new TextComponentTranslation("dwmh.status.data_error", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                    } else {
                        playerIn.func_146105_b(new TextComponentTranslation("dwmh.status.maximum_owned", new Object[]{count, ConfigHandler.entityMaximum}).func_150255_a(Util.DEFAULT_STYLE), true);
                    }
                    ItemOcarina.playSound(playerIn, true);
                }
            } else {
                boolean result = EntityTracking.unsetOwnerForEntity(playerIn, target);
                if (result) {
                    UUID nextEntity = EntityTracking.nextEntity(playerIn, target.func_110124_au());
                    if (nextEntity == null) {
                        tag.func_82580_o("targetMost");
                        tag.func_82580_o("targetLeast");
                    } else {
                        tag.func_186854_a("target", nextEntity);
                    }
                    playerIn.func_146105_b(new TextComponentTranslation("dwmh.status.success_unsetting_owner", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                } else {
                    playerIn.func_146105_b(new TextComponentTranslation("dwmh.status.data_error", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                }
                ItemOcarina.playSound(playerIn, true);
            }
            ItemOcarina.updateOcarinaNBT(stack, playerIn);
        }
    }

    public static void updateOcarinaNBT(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = Util.getOrCreateTagCompound(stack);
        tag.func_74782_a("info", (NBTBase)EntityTracking.getTrackedDataNBT(player));
        stack.func_77982_d(tag);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = Util.getOrCreateTagCompound(stack);
        if (!worldIn.field_72995_K) {
            WorldServer world = (WorldServer)worldIn;
            UUID entityId = null;
            if (tag.func_74764_b("targetLeast")) {
                entityId = tag.func_186857_a("target");
            }
            if (player.func_70093_af()) {
                UUID newId = EntityTracking.nextEntity(player, entityId);
                if (newId != null) {
                    ITextComponent nameComp = Util.resolveName(newId);
                    tag.func_186854_a("target", newId);
                    stack.func_77982_d(tag);
                    player.func_146105_b(new TextComponentTranslation("dwmh.status.now_tracking", new Object[]{nameComp}).func_150255_a(Util.DEFAULT_STYLE), true);
                    ItemOcarina.playSound(player);
                } else {
                    player.func_146105_b(new TextComponentTranslation("dwmh.status.no_entities", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                    ItemOcarina.playSound(player, true);
                }
            } else if (entityId != null) {
                EntityData data = DataHelper.getTrackingData();
                List<UUID> owned = data.ownerToEntities.get(player.func_110124_au());
                Entity entity = EntityTracking.fetchEntity(entityId, world, player);
                if (entity != null) {
                    if (owned != null && owned.contains(entity.func_110124_au())) {
                        entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        if (entity instanceof EntityLiving) {
                            EntityLiving el = (EntityLiving)entity;
                            el.func_70661_as().func_75499_g();
                        }
                        ItemOcarina.playSound(player);
                    } else {
                        player.func_146105_b(new TextComponentTranslation("dwmh.status.no_entities", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                    }
                } else {
                    player.func_146105_b(new TextComponentTranslation("dwmh.status.cant_find", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
                    ItemOcarina.playSound(player, true);
                }
            } else {
                player.func_146105_b(new TextComponentTranslation("dwmh.status.no_entities", new Object[0]).func_150255_a(Util.DEFAULT_STYLE), true);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        NBTTagCompound tag = Util.getOrCreateTagCompound(stack);
        UUID tracked = null;
        if (tag.func_186855_b("target")) {
            tracked = tag.func_186857_a("target");
        }
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.info1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.info2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.info3", (Object[])new Object[0]));
        tooltip.add("");
        NBTTagList info = null;
        if (tag.func_74764_b("info")) {
            info = tag.func_150295_c("info", 10);
        }
        if (info != null && !info.func_82582_d()) {
            tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.tracking_count", (Object[])new Object[]{info.func_74745_c()}));
            for (int i = 0; i < info.func_74745_c(); ++i) {
                NBTTagCompound entry = info.func_150305_b(i);
                String name = Util.resolveNameClient(entry.func_74779_i("name"));
                boolean isTracked = tracked != null && Objects.equals(entry.func_186857_a("entity"), tracked);
                tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.tracking_entry", (Object[])new Object[]{i, name, isTracked ? I18n.func_135052_a((String)"dwmh.tooltip.tracking_selected", (Object[])new Object[0]) : ""}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"dwmh.tooltip.tracking_empty", (Object[])new Object[0]));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    static {
        lastPlayedMap.defaultReturnValue(0L);
    }
}

