/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.dwmh.util;

import com.noobanidus.dwmh.ConfigHandler;
import com.noobanidus.dwmh.events.EventHandler;
import com.noobanidus.dwmh.world.DataHelper;
import com.noobanidus.dwmh.world.EntityData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class EntityTracking {
    public static WorldServer getWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new WrongSideException("Attempted to access server data on the client side!");
        }
        return EntityTracking.getWorld(0);
    }

    public static WorldServer getWorld(int id) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_71218_a(id);
    }

    public static EntityData getData() {
        return DataHelper.getTrackingData();
    }

    public static boolean setOwnerForEntity(EntityPlayer player, Entity entity) {
        EntityData data = EntityTracking.getData();
        UUID playerId = player.func_110124_au();
        UUID entityId = entity.func_110124_au();
        List ownedEntities = data.ownerToEntities.computeIfAbsent(playerId, o -> new ArrayList());
        if (ownedEntities.size() < ConfigHandler.entityMaximum) {
            data.entityToOwner.put(entityId, playerId);
            data.trackedEntities.add(entityId);
            data.entityToResourceLocation.put(entityId, EntityList.func_191301_a((Entity)entity));
            data.entityToName.put(entityId, EntityTracking.translationKey(entity));
            ownedEntities.add(entityId);
            EntityTracking.save();
            return true;
        }
        return false;
    }

    public static int entityCount(EntityPlayer player) {
        EntityData data = EntityTracking.getData();
        List ownedEntities = data.ownerToEntities.computeIfAbsent(player.func_110124_au(), o -> new ArrayList());
        return ownedEntities.size();
    }

    @Nullable
    public static Entity fetchEntity(UUID entityId, WorldServer world, EntityPlayer player) {
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer w = EntityTracking.getWorld(dim);
            Entity entity = w.func_175733_a(entityId);
            if (entity == null) continue;
            return entity;
        }
        EntityData data = EntityTracking.getData();
        NBTTagCompound entityTag = data.savedEntities.get(entityId);
        if (entityTag == null) {
            return null;
        }
        ResourceLocation resource = data.entityToResourceLocation.get(entityId);
        if (resource == null) {
            return null;
        }
        Entity result = EntityList.func_188429_b((ResourceLocation)resource, (World)world);
        if (result == null) {
            return null;
        }
        result.func_70020_e(entityTag);
        result.field_70128_L = false;
        result.func_70066_B();
        result.field_71093_bK = world.field_73011_w.getDimension();
        result.field_70172_ad = 0;
        if (result instanceof EntityLivingBase) {
            ((EntityLivingBase)result).func_70606_j(((EntityLivingBase)result).func_110138_aP());
        }
        result.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (result instanceof EntityLiving) {
            EntityLiving el = (EntityLiving)result;
            el.func_70661_as().func_75499_g();
        }
        EventHandler.isSpawning = true;
        player.field_70170_p.func_72838_d(result);
        EventHandler.isSpawning = false;
        return result;
    }

    @Nullable
    public static UUID nextEntity(EntityPlayer player, @Nullable UUID currentlyTracked) {
        EntityData data = EntityTracking.getData();
        List ownedEntities = data.ownerToEntities.computeIfAbsent(player.func_110124_au(), o -> new ArrayList());
        if (ownedEntities.isEmpty()) {
            return null;
        }
        if (currentlyTracked == null) {
            return (UUID)ownedEntities.get(0);
        }
        int index = ownedEntities.indexOf(currentlyTracked);
        if (index == -1) {
            return null;
        }
        if (index < ownedEntities.size() - 1) {
            return (UUID)ownedEntities.get(index + 1);
        }
        return (UUID)ownedEntities.get(0);
    }

    public static boolean unsetOwnerForEntity(EntityPlayer player, Entity entity) {
        EntityData data = EntityTracking.getData();
        UUID playerId = player.func_110124_au();
        UUID entityId = entity.func_110124_au();
        data.entityToOwner.remove(entityId);
        data.trackedEntities.remove(entityId);
        List<UUID> owned = data.ownerToEntities.get(playerId);
        if (owned != null) {
            owned.remove(entityId);
        }
        data.savedEntities.remove(entityId);
        data.storedEntities.remove(entityId);
        data.restoredEntities.remove(entityId);
        return true;
    }

    public static void save() {
        EntityData data = EntityTracking.getData();
        data.func_76185_a();
        WorldServer world = EntityTracking.getWorld();
        Objects.requireNonNull(world.func_175693_T()).func_75744_a();
    }

    @Nullable
    public static UUID getOwnerForEntity(Entity entity) {
        EntityData data = EntityTracking.getData();
        return data.entityToOwner.getOrDefault(entity.func_110124_au(), null);
    }

    public static String getName(UUID entityId) {
        EntityData data = EntityTracking.getData();
        return data.entityToName.get(entityId);
    }

    public static NBTTagList getTrackedDataNBT(EntityPlayer player) {
        NBTTagList tag = new NBTTagList();
        EntityData data = EntityTracking.getData();
        List<UUID> ownedEntities = data.ownerToEntities.get(player.func_110124_au());
        if (ownedEntities == null || ownedEntities.isEmpty()) {
            return tag;
        }
        for (UUID uuid : ownedEntities) {
            NBTTagCompound thisEntry = new NBTTagCompound();
            thisEntry.func_186854_a("entity", uuid);
            String name = data.entityToName.get(uuid);
            if (name == null) {
                thisEntry.func_74778_a("name", "");
            } else {
                thisEntry.func_74778_a("name", name);
            }
            tag.func_74742_a((NBTBase)thisEntry);
        }
        return tag;
    }

    private static String translationKey(Entity entity) {
        if (entity.func_145818_k_()) {
            return entity.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)entity);
        if (s == null) {
            s = "generic";
        }
        return "entity." + s + ".name";
    }

    public static class WrongSideException
    extends RuntimeException {
        public WrongSideException(String message) {
            super(message);
        }
    }
}

