/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.dwmh.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;

public class EntityData
extends WorldSavedData {
    public static final String id = "DudeWheresMyHorse-EntityTracking";
    public Set<UUID> trackedEntities = new HashSet<UUID>();
    public Map<UUID, UUID> entityToOwner = new HashMap<UUID, UUID>();
    public Map<UUID, List<UUID>> ownerToEntities = new HashMap<UUID, List<UUID>>();
    public Set<UUID> storedEntities = new HashSet<UUID>();
    public Set<UUID> restoredEntities = new HashSet<UUID>();
    public Map<UUID, NBTTagCompound> savedEntities = new HashMap<UUID, NBTTagCompound>();
    public Map<UUID, String> entityToName = new HashMap<UUID, String>();
    public Map<UUID, ResourceLocation> entityToResourceLocation = new HashMap<UUID, ResourceLocation>();

    public EntityData() {
        super(id);
    }

    public EntityData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        UUID entity;
        NBTTagCompound thisEntry;
        UUID entity2;
        this.entityToOwner.clear();
        this.trackedEntities.clear();
        this.ownerToEntities.clear();
        this.savedEntities.clear();
        this.storedEntities.clear();
        this.restoredEntities.clear();
        this.entityToName.clear();
        this.entityToResourceLocation.clear();
        NBTTagList owners = nbt.func_150295_c("owners", 10);
        for (int i = 0; i < owners.func_74745_c(); ++i) {
            NBTTagCompound thisEntry2 = owners.func_150305_b(i);
            UUID owner = thisEntry2.func_186857_a("owner");
            entity2 = thisEntry2.func_186857_a("entity");
            this.entityToOwner.put(entity2, owner);
            this.ownerToEntities.computeIfAbsent(owner, o -> new ArrayList()).add(entity2);
        }
        NBTTagList tracked = nbt.func_150295_c("tracked", 10);
        for (int i = 0; i < tracked.func_74745_c(); ++i) {
            NBTTagCompound thisEntry3 = tracked.func_150305_b(i);
            entity2 = thisEntry3.func_186857_a("entity");
            this.trackedEntities.add(entity2);
        }
        if (nbt.func_74764_b("savedData")) {
            NBTTagList entityData = nbt.func_150295_c("savedData", 10);
            for (int i = 0; i < entityData.func_74745_c(); ++i) {
                NBTTagCompound entry = entityData.func_150305_b(i);
                UUID entityId = entry.func_186857_a("id");
                NBTTagCompound data = entry.func_74775_l("data");
                this.savedEntities.put(entityId, data);
            }
        }
        if (nbt.func_74764_b("stored")) {
            NBTTagList stored = nbt.func_150295_c("stored", 10);
            for (int i = 0; i < stored.func_74745_c(); ++i) {
                thisEntry = stored.func_150305_b(i);
                entity = thisEntry.func_186857_a("entity");
                this.storedEntities.add(entity);
            }
        }
        if (nbt.func_74764_b("restored")) {
            NBTTagList restore = nbt.func_150295_c("restore", 10);
            for (int i = 0; i < restore.func_74745_c(); ++i) {
                thisEntry = restore.func_150305_b(i);
                entity = thisEntry.func_186857_a("entity");
                this.restoredEntities.add(entity);
            }
        }
        if (nbt.func_74764_b("names")) {
            NBTTagList names = nbt.func_150295_c("names", 10);
            for (int i = 0; i < names.func_74745_c(); ++i) {
                thisEntry = names.func_150305_b(i);
                entity = thisEntry.func_186857_a("entity");
                String name = thisEntry.func_74779_i("name");
                this.entityToName.put(entity, name);
            }
        }
        if (nbt.func_74764_b("resources")) {
            NBTTagList resources = nbt.func_150295_c("resources", 10);
            for (int i = 0; i < resources.func_74745_c(); ++i) {
                thisEntry = resources.func_150305_b(i);
                entity = thisEntry.func_186857_a("entity");
                ResourceLocation rl = new ResourceLocation(thisEntry.func_74779_i("resource"));
                this.entityToResourceLocation.put(entity, rl);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList owners = new NBTTagList();
        for (Map.Entry<UUID, UUID> entry : this.entityToOwner.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("entity", entry.getKey());
            nBTTagCompound.func_186854_a("owner", entry.getValue());
            owners.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList tracked = new NBTTagList();
        for (UUID uUID : this.trackedEntities) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("entity", uUID);
            tracked.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<UUID, NBTTagCompound> entry : this.savedEntities.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("id", entry.getKey());
            nBTTagCompound.func_74782_a("data", (NBTBase)entry.getValue());
        }
        NBTTagList nBTTagList2 = new NBTTagList();
        for (UUID uUID : this.storedEntities) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("entity", uUID);
            nBTTagList2.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList nBTTagList3 = new NBTTagList();
        for (UUID uUID : this.restoredEntities) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("entity", uUID);
            nBTTagList3.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList nBTTagList4 = new NBTTagList();
        for (Map.Entry<UUID, String> entry : this.entityToName.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("entity", entry.getKey());
            nBTTagCompound.func_74778_a("name", entry.getValue());
            nBTTagList4.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList nBTTagList5 = new NBTTagList();
        for (Map.Entry<UUID, ResourceLocation> entry : this.entityToResourceLocation.entrySet()) {
            NBTTagCompound thisEntry = new NBTTagCompound();
            thisEntry.func_186854_a("entity", entry.getKey());
            thisEntry.func_74778_a("resource", entry.getValue().toString());
            nBTTagList5.func_74742_a((NBTBase)thisEntry);
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("owners", (NBTBase)owners);
        nBTTagCompound.func_74782_a("tracked", (NBTBase)tracked);
        nBTTagCompound.func_74782_a("savedData", (NBTBase)nBTTagList);
        nBTTagCompound.func_74782_a("stored", (NBTBase)nBTTagList2);
        nBTTagCompound.func_74782_a("restored", (NBTBase)nBTTagList3);
        nBTTagCompound.func_74782_a("names", (NBTBase)nBTTagList4);
        nBTTagCompound.func_74782_a("resources", (NBTBase)nBTTagList5);
        return nBTTagCompound;
    }
}

