/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.collect.Lists;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.widgets.IScrollable;
import javax.annotation.Nullable;

public class ScrollableElement
extends ElementGroup
implements IScrollable {
    @Nullable
    private IGuiElement content;
    private float scrollPercentage;
    private float step;

    public ScrollableElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.addSelfEventHandler(GuiEvent.WheelEvent.class, event -> {});
    }

    public int getInvisibleArea() {
        this.step = 6.0f;
        if (this.content == null) {
            return 0;
        }
        return (int)((float)(this.content.getHeight() - this.height) / this.step);
    }

    protected void movePercentage(float percentage) {
        this.scrollPercentage = percentage * this.step;
    }

    @Override
    public void onScroll(int value) {
        this.scrollPercentage = (float)value * this.step;
        if (this.content != null) {
            this.content.setOffset(0, -((int)this.scrollPercentage));
        }
    }

    public void setContent(@Nullable IGuiElement content) {
        this.content = content;
        if (content != null) {
            content.setCroppedZone(this, 0, 0, this.width, this.height);
        }
    }

    @Override
    public void clear() {
        this.remove(Lists.newArrayList((Iterable)this.elements));
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver();
    }
}

