/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openmods.Log;
import openmods.sync.ISyncMapProvider;
import openmods.sync.SyncMapServer;
import openmods.utils.NetUtils;

public class SyncMapEntity
extends SyncMapServer {
    private final Entity owner;
    public static final int OWNER_TYPE = 0;

    public SyncMapEntity(Entity owner, SyncMapServer.UpdateStrategy strategy) {
        super(strategy);
        this.owner = owner;
    }

    public static ISyncMapProvider findOwner(World world, PacketBuffer input) {
        int entityId = input.readInt();
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof ISyncMapProvider) {
            return (ISyncMapProvider)entity;
        }
        Log.warn("Invalid handler info: can't find ISyncHandler entity id %d", entityId);
        return null;
    }

    @Override
    protected int getOwnerType() {
        return 0;
    }

    @Override
    protected void writeOwnerData(PacketBuffer outputBuffer) {
        outputBuffer.writeInt(this.owner.func_145782_y());
    }

    @Override
    protected Set<EntityPlayerMP> getPlayersWatching() {
        return NetUtils.getPlayersWatchingEntity((WorldServer)this.owner.field_70170_p, this.owner);
    }

    @Override
    protected boolean isInvalid() {
        return this.owner.field_70128_L;
    }
}

