/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models;

import ivorius.ivtoolkit.models.NodePart;
import ivorius.ivtoolkit.models.utils.MatrixMathUtils;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;

public class Node {
    public String id;
    public Node parent;
    public final List<Node> children = new ArrayList<Node>(2);
    public boolean isAnimated;
    public final Vector3f translation = new Vector3f();
    public final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public final Matrix4f localTransform = new Matrix4f();
    public final Matrix4f globalTransform = new Matrix4f();
    public List<NodePart> parts = new ArrayList<NodePart>(2);

    public void calculateLocalTransform() {
        MatrixMathUtils.setTRS(this.localTransform, this.translation, this.rotation, this.scale);
    }

    public void calculateGlobalTransform() {
        this.globalTransform.load(this.localTransform);
        if (this.parent != null) {
            Matrix4f.mul((Matrix4f)this.parent.globalTransform, (Matrix4f)this.globalTransform, (Matrix4f)this.globalTransform);
        }
    }

    public void calculateTransforms(boolean recursive) {
        this.calculateLocalTransform();
        this.calculateGlobalTransform();
        if (recursive) {
            for (Node child : this.children) {
                child.calculateTransforms(true);
            }
        }
    }

    public void calculateBoneTransforms(boolean recursive) {
        for (NodePart part : this.parts) {
            if (part.invBoneBindTransforms == null || part.bones == null || part.invBoneBindTransforms.size != part.bones.length) continue;
            int n = part.invBoneBindTransforms.size;
            for (int i = 0; i < n; ++i) {
                part.bones[i].load(((Node[])part.invBoneBindTransforms.keys)[i].globalTransform);
                Matrix4f.mul((Matrix4f)part.bones[i], (Matrix4f)((Matrix4f[])part.invBoneBindTransforms.values)[i], (Matrix4f)part.bones[i]);
            }
        }
        if (recursive) {
            for (Node child : this.children) {
                child.calculateBoneTransforms(true);
            }
        }
    }
}

