/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.block;

import com.google.common.collect.Lists;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.block.BlockTyped;
import ivorius.reccomplex.block.materials.RCMaterials;
import ivorius.reccomplex.utils.UnstableBlock;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockGenericSpace
extends BlockTyped
implements UnstableBlock {
    public static final PropertyBool VISIBLE = PropertyBool.func_177716_a((String)"visible");
    public static final AxisAlignedBB SPACE_AABB;

    public BlockGenericSpace() {
        super(RCMaterials.materialNegativeSpace);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SPACE_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return RCConfig.hideRedundantNegativeSpace && Stream.of(EnumFacing.field_82609_l).allMatch(f -> this.hideableAtSide(state, worldIn, pos, (EnumFacing)f)) ? state.func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)) : state.func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(true));
    }

    protected boolean hideableAtSide(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing f) {
        IBlockState sideState = worldIn.func_180495_p(pos.func_177972_a(f));
        return sideState.func_177230_c() == this && Objects.equals(sideState.func_177229_b((IProperty)TYPE), sideState.func_177229_b((IProperty)TYPE));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, VISIBLE});
    }

    static {
        float lowB = 0.3125f;
        float highB = 1.0f - lowB;
        SPACE_AABB = new AxisAlignedBB((double)lowB, (double)lowB, (double)lowB, (double)highB, (double)highB, (double)highB);
    }
}

