/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client.rendering;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.AreaRenderer;
import ivorius.ivtoolkit.rendering.grid.CubeMesh;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.utils.Icons;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class OperationRenderer {
    public static void applyTransformVisual(AxisAlignedTransform2D transform2D, float[] size) {
        if (transform2D.getRotation() % 2 == 1) {
            GlStateManager.func_179109_b((float)(size[2] * 0.5f), (float)0.0f, (float)(size[0] * 0.5f));
        } else {
            GlStateManager.func_179109_b((float)(size[0] * 0.5f), (float)0.0f, (float)(size[2] * 0.5f));
        }
        GlStateManager.func_179114_b((float)(-90.0f * (float)transform2D.getRotation()), (float)0.0f, (float)1.0f, (float)0.0f);
        if (transform2D.isMirrorX()) {
            GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179109_b((float)(-size[0] * 0.5f), (float)0.0f, (float)(-size[2] * 0.5f));
    }

    public static void renderGridQuadCache(GridQuadCache<?> cached, AxisAlignedTransform2D transform, BlockPos lowerCoord, int ticks, float partialTicks) {
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179129_p();
        ResourceLocation curTex = Icons.frame(SelectionRenderer.LATTICE_TEXTURE, ((float)ticks + partialTicks) * 0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)lowerCoord.func_177958_n(), (float)lowerCoord.func_177956_o(), (float)lowerCoord.func_177952_p());
        OperationRenderer.applyTransformVisual(transform, cached.getSize());
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (GridQuadCache.CachedQuadLevel<?> cachedQuadLevel : cached) {
            EnumFacing direction = cachedQuadLevel.direction;
            float zLevel = cachedQuadLevel.zLevel + 0.01f * (float)(direction.func_82601_c() + direction.func_96559_d() + direction.func_82599_e());
            FloatBuffer quads = cachedQuadLevel.quads;
            while (quads.position() < quads.limit() - 3) {
                float minX = quads.get();
                float minY = quads.get();
                float maxX = quads.get();
                float maxY = quads.get();
                float[] minAxes = GridQuadCache.getNormalAxes(direction, zLevel, minX, minY);
                float[] maxAxes = GridQuadCache.getNormalAxes(direction, zLevel, maxX, maxY);
                CubeMesh.renderSide(direction, minAxes[0], minAxes[1], minAxes[2], maxAxes[0], maxAxes[1], maxAxes[2], Icons.from(minX, minY, maxX, maxY));
            }
            quads.position(0);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179092_a((int)516, (float)0.002f);
        GlStateManager.func_179084_k();
    }

    @Nullable
    public static BlockArea blockAreaFromSize(BlockPos lowerCoord, int[] size) {
        return size[0] > 0 && size[1] > 0 && size[2] > 0 ? BlockArea.areaFromSize(lowerCoord, size) : null;
    }

    public static void renderBoundingBox(@Nullable BlockArea area, int ticks, float partialTicks) {
        if (area == null) {
            return;
        }
        GL11.glLineWidth((float)3.0f);
        GlStateManager.func_179124_c((float)0.8f, (float)0.8f, (float)1.0f);
        AreaRenderer.renderAreaLined(area, 0.0232f);
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179092_a((int)516, (float)1.0E-4f);
        ResourceLocation curTex = Icons.frame(SelectionRenderer.TEXTURE, ((float)ticks + partialTicks) * 0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
        GlStateManager.func_179131_c((float)0.6f, (float)0.6f, (float)0.8f, (float)0.3f);
        AreaRenderer.renderArea(area, false, true, 0.0132f);
        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)1.0f, (float)0.5f);
        AreaRenderer.renderArea(area, false, false, 0.0132f);
        GlStateManager.func_179092_a((int)516, (float)0.002f);
        GlStateManager.func_179084_k();
    }
}

