/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.Repository;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.info.CommandDimensionDict;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.ArrayUtils;

public class RCTextStyle {
    @Nonnull
    public static ITextComponent visit(File file, String ... path) {
        TextComponentString pathComponent = new TextComponentString(String.join((CharSequence)"/", path));
        pathComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        pathComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Visit File")));
        pathComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
        return pathComponent;
    }

    @Nonnull
    public static ITextComponent path(ResourceDirectory directory, String ... path) {
        return RCTextStyle.visit(directory.toFile(), (String[])ArrayUtils.add((Object[])path, (int)0, (Object)directory.toString()));
    }

    @Nonnull
    public static ITextComponent submit(String id) {
        ITextComponent submit = RecurrentComplex.translations.get("reccomplex.save.submit");
        submit.func_150256_b().func_150238_a(TextFormatting.AQUA);
        submit.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("reccomplex.save.submit.hover")));
        submit.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, Repository.submitURL(id)));
        return submit;
    }

    public static ITextComponent users(@Nullable String names) {
        boolean has;
        boolean bl = has = names != null && !names.trim().isEmpty();
        if (!has) {
            return RecurrentComplex.translations.format("commands.rclookup.reply.noauthor", new Object[0]);
        }
        TextComponentString component = new TextComponentString(RCStrings.abbreviateFormatted(names, 30));
        component.func_150256_b().func_150238_a(TextFormatting.GOLD);
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(names)));
        return component;
    }

    public static ITextComponent structure(String id) {
        TextComponentString comp = new TextComponentString(id);
        comp.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s", RCCommands.structures.lookup(id))));
        comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rcsearch.lookup")));
        comp.func_150256_b().func_150238_a(TextFormatting.AQUA);
        return comp;
    }

    public static TextComponentString biome(ResourceLocation id) {
        return (TextComponentString)RCTextStyle.biome((Biome)Biome.field_185377_q.func_82594_a((Object)id));
    }

    @Nonnull
    public static ITextComponent biome(Biome biome) {
        TextComponentString component = new TextComponentString(biome.func_185359_l());
        Style style = component.func_150256_b();
        style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s types %s", RCCommands.biomeDict.func_71517_b(), biome.getRegistryName())));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.format("commands.biomedict.list.number", BiomeDictionary.getTypes((Biome)biome).size())));
        style.func_150238_a(TextFormatting.AQUA);
        return component;
    }

    @Nonnull
    public static ITextComponent biomeType(BiomeDictionary.Type type) {
        TextComponentString component = new TextComponentString(type.getName());
        Style style = component.func_150256_b();
        style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s list %s", RCCommands.biomeDict.func_71517_b(), type)));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.format("commands.biomedict.get.number", BiomeDictionary.getBiomes((BiomeDictionary.Type)type).size())));
        style.func_150238_a(TextFormatting.AQUA);
        return component;
    }

    @Nonnull
    public static ITextComponent dimension(int dimensionID) {
        TextComponentString component = new TextComponentString(String.valueOf(dimensionID));
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s types %s", RCCommands.dimensionDict.func_71517_b(), dimensionID)));
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.format("commands.dimensiondict.list.number", DimensionDictionary.getDimensionTypes(DimensionManager.getProvider((int)dimensionID)).size())));
        return component;
    }

    @Nonnull
    public static ITextComponent dimensionType(String type) {
        TextComponentString component = new TextComponentString(type);
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s list %s", RCCommands.dimensionDict.func_71517_b(), type)));
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.format("commands.dimensiondict.get.number", CommandDimensionDict.allDimensionsOfType(type).size())));
        return component;
    }

    public static ITextComponent area(BlockPos left, BlockPos right) {
        return left == null || right == null ? RecurrentComplex.translations.format("commands.rcarea.get", RCTextStyle.pos(left), RCTextStyle.pos(right)) : RCTextStyle.area(new BlockArea(left, right));
    }

    public static ITextComponent area(BlockArea area) {
        ITextComponent component = RecurrentComplex.translations.format("commands.rcarea.get", RCTextStyle.pos(area.getPoint1()), RCTextStyle.pos(area.getPoint2()));
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rcarea.select")));
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s %s %d %d %d %d %d %d --first --second", RCCommands.select.func_71517_b(), RCCommands.select.set.func_71517_b(), area.getPoint1().func_177958_n(), area.getPoint1().func_177956_o(), area.getPoint1().func_177952_p(), area.getPoint2().func_177958_n(), area.getPoint2().func_177956_o(), area.getPoint2().func_177952_p())));
        return component;
    }

    @Nonnull
    public static ITextComponent sight(WorldStructureGenerationData.Entry entry) {
        return RCTextStyle.sight(entry, false);
    }

    public static ITextComponent sight(WorldStructureGenerationData.Entry entry, boolean useID) {
        ITextComponent name;
        TextComponentString forget = new TextComponentString("X");
        String uuidString = entry.getUuid().toString();
        forget.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s %s id %s", RCCommands.sight.func_71517_b(), RCCommands.sight.delete.func_71517_b(), uuidString)));
        forget.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.format("commands.rcforget.forget", uuidString)));
        forget.func_150256_b().func_150238_a(TextFormatting.RED);
        if (useID) {
            name = RCTextStyle.copy(entry.getUuid().toString());
        } else {
            name = new TextComponentString(entry.description());
            name.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rcsightinfo.lookup")));
            name.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s %s %s", RCCommands.sight.func_71517_b(), RCCommands.sight.info.func_71517_b(), entry.getUuid())));
        }
        name.func_150256_b().func_150238_a(TextFormatting.AQUA);
        return new TextComponentTranslation("%s (%s)", new Object[]{name, forget});
    }

    public static ITextComponent vanillaSight(MapGenStructure mapGen) {
        TextComponentString name = new TextComponentString(mapGen.func_143025_a());
        name.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Vanilla Structure")));
        return name;
    }

    public static ITextComponent vanillaComponentSight(StructureComponent component) {
        TextComponentString name = new TextComponentString(MapGenStructureIO.func_143036_a((StructureComponent)component));
        name.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Vanilla Structure Component")));
        return name;
    }

    public static ITextComponent copy(String text) {
        TextComponentString comp = new TextComponentString(text);
        comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rccopy.suggest")));
        comp.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text));
        return comp;
    }

    public static ITextComponent chunkPos(ChunkPos pos) {
        return pos != null ? RecurrentComplex.translations.format("commands.rcchunkpos.get", pos.field_77276_a, pos.field_77275_b) : RecurrentComplex.translations.format("commands.selectSet.point.none", new Object[0]);
    }

    public static ITextComponent pos(BlockPos pos) {
        return pos != null ? RecurrentComplex.translations.format("commands.rcpos.get", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : RecurrentComplex.translations.format("commands.selectSet.point.none", new Object[0]);
    }

    public static ITextComponent size(int[] size) {
        return size != null ? RecurrentComplex.translations.format("commands.rcsize.get", size[0], size[1], size[2]) : RecurrentComplex.translations.format("commands.selectSet.point.none", new Object[0]);
    }
}

