/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.files;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.files.saving.FileSaverAdapter;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.utils.RawResourceLocation;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.ResourceExpression;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class CommandWrite
extends CommandExpecting {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "write";
    }

    public int func_82362_a() {
        return 4;
    }

    @Override
    public void expect(Expect expect) {
        expect.next(RecurrentComplex.saver.keySet()).descriptionU("file type").required().next(params -> params.get(0).tryGet().map(RecurrentComplex.saver::get).map(a -> a.getRegistry().ids())).descriptionU("resource expression").repeat().named("directory", "d").then(RCE::resourceDirectory);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        String adapterID = parameters.get(0).require();
        if (!RecurrentComplex.saver.has(adapterID)) {
            throw RecurrentComplex.translations.commandException("commands.rcsave.noregistry", new Object[0]);
        }
        ResourceDirectory directory = parameters.get("directory").to(RCP::resourceDirectory).optional().orElse(ResourceDirectory.ACTIVE);
        Optional<FileSaverAdapter> adapterOptional = Optional.ofNullable(RecurrentComplex.saver.get(adapterID));
        Set ids = adapterOptional.map(a -> a.getRegistry().ids()).orElse(Collections.emptySet());
        ResourceExpression resourceExpression = ExpressionCache.of(new ResourceExpression(id -> adapterOptional.map(a -> a.getRegistry().has((String)id)).orElse(false)), parameters.get(1).rest(NaP::join).require());
        int saved = 0;
        int failed = 0;
        for (String id2 : ids) {
            if (!resourceExpression.test(new RawResourceLocation(adapterOptional.map(a -> a.getRegistry().status(id2).getDomain()).orElseThrow(IllegalStateException::new), id2))) continue;
            boolean success = RecurrentComplex.saver.trySave(directory.toPath(), adapterID, id2);
            if (success) {
                ++saved;
                continue;
            }
            ++failed;
        }
        commandSender.func_145747_a(RecurrentComplex.translations.format("commands.rcsaveall.result", saved, RCTextStyle.path(directory, new String[0]), failed));
        RCCommands.tryReload(RecurrentComplex.loader, LeveledRegistry.Level.CUSTOM);
        RCCommands.tryReload(RecurrentComplex.loader, LeveledRegistry.Level.SERVER);
    }
}

