/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.loading;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.loading.FileLoadContext;
import ivorius.reccomplex.files.loading.FileLoaderAdapter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.ParametersAreNonnullByDefault;

public abstract class FileLoaderString<S>
extends FileLoaderAdapter {
    public FileLoaderString(String suffix) {
        super(suffix);
    }

    @ParametersAreNonnullByDefault
    public abstract boolean loadFile(String var1, Path var2, String var3, FileLoadContext var4) throws Exception;

    @Override
    @ParametersAreNonnullByDefault
    public boolean loadFile(Path path, String id, FileLoadContext context) {
        String resource = null;
        try {
            resource = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            RecurrentComplex.logger.error("Resource is damaged: " + path, (Throwable)e);
        }
        if (resource == null) {
            return false;
        }
        try {
            return this.loadFile(resource, path, id, context);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error loading resource: " + path, (Throwable)e);
            return false;
        }
    }
}

