/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.reccomplex.RecurrentComplex;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTexturedButton
extends GuiButton {
    private ResourceLocation texture;
    private int textureWidth;
    private int textureHeight;

    public GuiTexturedButton(int buttonId, int x, int y, ResourceLocation texture) {
        super(buttonId, x, y, "");
        this.setTexture(texture);
    }

    public GuiTexturedButton(int buttonId, int x, int y, int widthIn, int heightIn, ResourceLocation texture) {
        super(buttonId, x, y, widthIn, heightIn, "");
        this.setTexture(texture);
    }

    public GuiTexturedButton(int buttonId, int x, int y, String buttonText) {
        super(buttonId, x, y, buttonText);
    }

    public GuiTexturedButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
        if (texture != null) {
            try {
                IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture);
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                this.textureWidth = bufferedimage.getWidth();
                this.textureHeight = bufferedimage.getHeight();
            }
            catch (IOException e) {
                RecurrentComplex.logger.error((Object)e);
                this.texture = null;
            }
        }
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        if (this.field_146125_m && this.texture != null) {
            mc.func_110434_K().func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.drawTexture(this.field_146128_h + (this.field_146120_f - this.textureWidth) / 2, this.field_146129_i + (this.field_146121_g - this.textureHeight) / 2, 0, 0, this.textureWidth, this.textureHeight);
        }
    }

    public void drawTexture(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) / (float)this.textureWidth), (double)((float)(textureY + height) / (float)this.textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) / (float)this.textureWidth), (double)((float)(textureY + height) / (float)this.textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) / (float)this.textureWidth), (double)((float)(textureY + 0) / (float)this.textureHeight)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) / (float)this.textureWidth), (double)((float)(textureY + 0) / (float)this.textureHeight)).func_181675_d();
        tessellator.func_78381_a();
    }
}

