/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.rendering.grid.AreaRenderer;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.utils.ItemHandlers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class OperationClearArea
implements Operation {
    public BlockArea sourceArea;

    public OperationClearArea() {
    }

    public OperationClearArea(BlockArea sourceArea) {
        this.sourceArea = sourceArea;
    }

    public static void setBlockToAirClean(World world, BlockPos pos) {
        OperationClearArea.emptyOut(world, pos);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    public static void emptyOut(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && ItemHandlers.hasModifiable((ICapabilityProvider)tileEntity)) {
            ItemHandlers.clear(ItemHandlers.getModifiable((ICapabilityProvider)tileEntity));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (this.sourceArea != null) {
            BlockPositions.writeToNBT("sourcePoint1", this.sourceArea.getPoint1(), compound);
            BlockPositions.writeToNBT("sourcePoint2", this.sourceArea.getPoint2(), compound);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.sourceArea = OperationClearArea.blockAreaFrom(BlockPositions.readFromNBT("sourcePoint1", compound), BlockPositions.readFromNBT("sourcePoint2", compound));
    }

    public static BlockArea blockAreaFrom(BlockPos left, BlockPos right) {
        return left != null && right != null ? new BlockArea(left, right) : null;
    }

    @Override
    public void perform(WorldServer world) {
        if (this.sourceArea != null) {
            for (BlockPos coord : this.sourceArea) {
                OperationClearArea.setBlockToAirClean((World)world, coord);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        if (this.sourceArea != null && (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE)) {
            GL11.glLineWidth((float)3.0f);
            GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)1.0f);
            AreaRenderer.renderAreaLined(this.sourceArea, 0.0212f);
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179092_a((int)516, (float)1.0E-4f);
            ResourceLocation curTex = SelectionRenderer.TEXTURE[MathHelper.func_76141_d((float)(((float)ticks + partialTicks) * 0.75f)) % SelectionRenderer.TEXTURE.length];
            Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
            GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.4f, (float)0.2f);
            AreaRenderer.renderArea(this.sourceArea, false, true, 0.0112f);
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.5f, (float)0.35f);
            AreaRenderer.renderArea(this.sourceArea, false, false, 0.0112f);
            GlStateManager.func_179092_a((int)516, (float)0.002f);
            GlStateManager.func_179084_k();
        }
    }
}

