/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.tools.Ranges;
import ivorius.ivtoolkit.tools.Visitor;

public class IntAreas {
    public static boolean visitAllCoords(int[] lower, int[] higher, Visitor<int[]> visitor) {
        return IntAreas.visitCoords(lower, higher, (int[])lower.clone(), (TIntList)new TIntArrayList(Ranges.to(lower.length)), visitor);
    }

    public static boolean visitCoords(int[] lower, int[] higher, TIntList dimensions, Visitor<int[]> visitor) {
        return IntAreas.visitCoords(lower, higher, (int[])lower.clone(), dimensions, visitor);
    }

    public static boolean visitCoordsExcept(int[] lower, int[] higher, TIntList except, Visitor<int[]> visitor) {
        TIntArrayList dimensions = new TIntArrayList(Ranges.to(lower.length));
        dimensions.removeAll((TIntCollection)except);
        return IntAreas.visitCoords(lower, higher, (int[])lower.clone(), (TIntList)dimensions, visitor);
    }

    public static boolean visitCoords(int[] lower, int[] higher, int[] coord, TIntList dimensions, Visitor<int[]> visitor) {
        int dim = dimensions.get(0);
        coord[dim] = lower[dim];
        while (coord[dim] <= higher[dim]) {
            if (dimensions.size() == 1 ? !visitor.visit(coord) : !IntAreas.visitCoords(lower, higher, coord, dimensions.subList(1, dimensions.size()), visitor)) {
                return false;
            }
            int n = dim;
            coord[n] = coord[n] + 1;
        }
        return true;
    }
}

