/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.util.LineSelection;
import ivorius.ivtoolkit.util.LineSelections;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class GenericPlacer {
    public final List<Factor> factors = new ArrayList<Factor>();

    public GenericPlacer() {
    }

    public GenericPlacer(List<Factor> factors) {
        this.factors.addAll(factors);
    }

    public int place(StructurePlaceContext context, @Nullable IvBlockCollection blockCollection, Set<BlockPos> surface) {
        if (this.factors.isEmpty()) {
            return -1;
        }
        WorldServer world = context.environment.world;
        WorldCache cache = new WorldCache((World)world, StructureBoundingBoxes.wholeHeightBoundingBox(world, context.boundingBox));
        LineSelection considerable = LineSelection.fromRange(new IntegerRange(0, world.func_72800_K() - context.boundingBox.func_78882_c()), true);
        ArrayList considerations = new ArrayList();
        this.factors.forEach(factor -> {
            List<Object> consideration = factor.consider(cache, considerable, blockCollection, surface, context);
            consideration.stream().filter(p -> ((Float)p.getRight()).floatValue() <= 0.0f).forEach(p -> considerable.set((LineSelection)p.getLeft(), true, false));
            consideration = consideration.stream().filter(p -> ((Float)p.getRight()).floatValue() > 0.0f).collect(Collectors.toList());
            considerable.set(LineSelections.combine(consideration.stream().map(Pair::getLeft), true), false, false);
            considerations.addAll(consideration);
        });
        Set applicable = considerable.streamElements(null, true).mapToObj(y -> Pair.of((Object)y, (Object)considerations.stream().mapToDouble(pair -> ((LineSelection)pair.getLeft()).isSectionAdditive(((LineSelection)pair.getLeft()).sectionForIndex(y)) ? (double)((Float)pair.getRight()).floatValue() : 1.0).reduce(1.0, (left, right) -> left * right))).filter(p -> (Double)p.getRight() > 0.0).collect(Collectors.toSet());
        return applicable.size() > 0 ? (Integer)WeightedSelector.select(context.random, applicable, Pair::getRight).getLeft() : -1;
    }

    public static class Serializer
    implements JsonSerializer<GenericPlacer>,
    JsonDeserializer<GenericPlacer> {
        public GenericPlacer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "placer");
            List<Factor> factors = (List<Factor>)FactorRegistry.INSTANCE.gson.fromJson(jsonObject.get("factors"), new TypeToken<List<Factor>>(){}.getType());
            if (factors == null) {
                factors = Collections.emptyList();
            }
            return new GenericPlacer(factors);
        }

        public JsonElement serialize(GenericPlacer src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("factors", FactorRegistry.INSTANCE.gson.toJsonTree(src.factors));
            return jsonObject;
        }

        public static enum SelectionMode {
            BEDROCK,
            SURFACE,
            SEALEVEL,
            UNDERWATER,
            TOP,
            LOWEST_EDGE;

        }
    }

    public static abstract class Factor {
        public float priority;

        public Factor(float priority) {
            this.priority = priority;
        }

        public float weight(float weight) {
            return (float)Math.pow(weight, this.priority);
        }

        public String displayString() {
            return IvTranslations.get("reccomplex.placer.factors." + FactorRegistry.INSTANCE.getTypeRegistry().iDForType(this.getClass()));
        }

        @SideOnly(value=Side.CLIENT)
        public abstract TableDataSource tableDataSource(TableNavigator var1, TableDelegate var2);

        public abstract List<Pair<LineSelection, Float>> consider(WorldCache var1, LineSelection var2, @Nullable IvBlockCollection var3, Set<BlockPos> var4, StructurePlaceContext var5);
    }
}

