/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.villages;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaGeneration;
import ivorius.reccomplex.world.gen.feature.villages.GenericVillagePiece;
import ivorius.reccomplex.world.gen.feature.villages.VanillaGenerationClassFactory;
import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class GenericVillageCreationHandler
implements VillagerRegistry.IVillageCreationHandler {
    protected String structureID;
    protected String generationID;

    public GenericVillageCreationHandler(String structureID, String generationID) {
        this.structureID = structureID;
        this.generationID = generationID;
    }

    public static GenericVillageCreationHandler forGeneration(String structureID, String generationID) {
        return GenericVillageCreationHandler.getPieceClass(structureID, generationID) != null ? new GenericVillageCreationHandler(structureID, generationID) : null;
    }

    public static Class<? extends GenericVillagePiece> getPieceClass(String structureID, String generationID) {
        return VanillaGenerationClassFactory.instance().getClass(structureID, generationID);
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int villageSize) {
        Structure structure;
        Structure structure2 = structure = StructureRegistry.INSTANCE.hasActive(this.structureID) ? (Structure)StructureRegistry.INSTANCE.get(this.structureID) : null;
        if (structure != null) {
            float tweakedWeight = RCConfig.tweakedSpawnRate(this.structureID);
            GenerationType generationType = structure.generationType(this.generationID);
            if (generationType instanceof VanillaGeneration) {
                VanillaGeneration vanillaGenInfo = (VanillaGeneration)generationType;
                int spawnLimit = MathHelper.func_76128_c((double)(MathHelper.func_82716_a((Random)random, (double)(vanillaGenInfo.minBaseLimit + (double)villageSize * vanillaGenInfo.minScaledLimit), (double)(vanillaGenInfo.maxBaseLimit + (double)villageSize * vanillaGenInfo.maxScaledLimit)) + 0.5));
                return new StructureVillagePieces.PieceWeight(this.getComponentClass(), vanillaGenInfo.getVanillaWeight(tweakedWeight), spawnLimit);
            }
        }
        return new StructureVillagePieces.PieceWeight(this.getComponentClass(), 0, 0);
    }

    public Class<? extends StructureVillagePieces.Village> getComponentClass() {
        return GenericVillageCreationHandler.getPieceClass(this.structureID, this.generationID);
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int x, int y, int z, EnumFacing front, int generationDepth) {
        Structure structure = (Structure)StructureRegistry.INSTANCE.get(this.structureID);
        if (structure == null) {
            return this.kill(villagePiece);
        }
        GenerationType generationType = structure.generationType(this.generationID);
        if (!(generationType instanceof VanillaGeneration)) {
            return this.kill(villagePiece);
        }
        VanillaGeneration vanillaGenInfo = (VanillaGeneration)generationType;
        AxisAlignedTransform2D transform = GenericVillagePiece.getTransform(vanillaGenInfo.front, structure.isMirrorable(), structure.isRotatable(), front.func_176734_d(), random);
        if (!vanillaGenInfo.generatesIn(startPiece.biome) || transform == null) {
            return this.kill(villagePiece);
        }
        int[] structureSize = RCAxisAlignedTransform.applySize(transform, structure.size());
        StructureBoundingBox strucBB = Structures.boundingBox(new BlockPos(x, y, z), structureSize);
        if (!GenericVillagePiece.canVillageGoDeeperC(strucBB) || StructureComponent.func_74883_a(pieces, (StructureBoundingBox)strucBB) != null) {
            return null;
        }
        GenericVillagePiece genericVillagePiece = GenericVillagePiece.create(this.structureID, this.generationID, startPiece, generationDepth);
        genericVillagePiece.seed = random.nextLong();
        if (genericVillagePiece == null) {
            return this.kill(villagePiece);
        }
        genericVillagePiece.setIds(this.structureID, this.generationID);
        genericVillagePiece.setOrientation(front, transform, strucBB);
        return genericVillagePiece;
    }

    public StructureVillagePieces.Village kill(StructureVillagePieces.PieceWeight piece) {
        piece.field_75089_c = piece.field_75087_d;
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericVillageCreationHandler that = (GenericVillageCreationHandler)o;
        if (!this.structureID.equals(that.structureID)) {
            return false;
        }
        return this.generationID.equals(that.generationID);
    }

    public int hashCode() {
        int result = this.structureID.hashCode();
        result = 31 * result + this.generationID.hashCode();
        return result;
    }
}

