/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.exnihilocreatio;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.CrookReward;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.StackInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.api.SieveModelBounds;
import net.blay09.mods.excompressum.api.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;

public class ExNihiloCreatioAddon
implements ExNihiloProvider,
IAddon {
    private final EnumMap<ExNihiloProvider.NihiloItems, ItemStack> itemMap = Maps.newEnumMap(ExNihiloProvider.NihiloItems.class);
    private final SieveModelBounds bounds;
    private Enchantment sieveEfficiency;
    private Enchantment sieveFortune;
    private ItemStack woodenCrucible;

    public ExNihiloCreatioAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.bounds = new SieveModelBounds(0.8125f, 0.0625f, 0.88f, 0.15625f);
        ExNihiloRegistryManager.registerHammerDefaultRecipeHandler(hammerRegistry -> {
            if (ModConfig.general.enableWoodChippings) {
                hammerRegistry.register("logWood", new ItemStack(ModItems.woodChipping), 0, 1.0f, 1.0f);
                hammerRegistry.register("logWood", new ItemStack(ModItems.woodChipping), 0, 0.75f, 1.0f);
                hammerRegistry.register("logWood", new ItemStack(ModItems.woodChipping), 0, 0.5f, 1.0f);
                hammerRegistry.register("logWood", new ItemStack(ModItems.woodChipping), 0, 0.25f, 1.0f);
            }
        });
        ExNihiloRegistryManager.registerCompostDefaultRecipeHandler(compostRegistry -> {
            if (ModConfig.general.enableWoodChippings) {
                compostRegistry.register("dustWood", 0.125f, new BlockInfo(Blocks.field_150346_d), new Color(-3704794));
            }
        });
        ExRegistro.instance = this;
    }

    @Override
    public void registriesComplete() {
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_WOODEN, this.findItem("hammer_wood", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_STONE, this.findItem("hammer_stone", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_IRON, this.findItem("hammer_iron", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_GOLD, this.findItem("hammer_gold", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_DIAMOND, this.findItem("hammer_diamond", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.CROOK_WOODEN, this.findItem("crook_wood", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SILK_MESH, this.findItem("item_mesh", 1));
        this.itemMap.put(ExNihiloProvider.NihiloItems.IRON_MESH, this.findItem("item_mesh", 3));
        this.itemMap.put(ExNihiloProvider.NihiloItems.DUST, this.findBlock("block_dust", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SIEVE, this.findBlock("block_sieve", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.INFESTED_LEAVES, this.findBlock("block_infested_leaves", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.NETHER_GRAVEL, this.findBlock("block_netherrack_crushed", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.ENDER_GRAVEL, this.findBlock("block_endstone_crushed", 0));
        this.woodenCrucible = this.findBlock("block_crucible_wood", 0);
    }

    @Override
    public void init() {
        ItemStack diamondMeshItem;
        ItemStack ironMeshItem;
        ItemStack flintMeshItem;
        this.sieveEfficiency = Enchantment.func_180305_b((String)"exnihilocreatio:sieve_efficiency");
        this.sieveFortune = Enchantment.func_180305_b((String)"exnihilocreatio:sieve_fortune");
        ItemStack stringMeshItem = this.getNihiloItem(ExNihiloProvider.NihiloItems.SILK_MESH);
        if (!stringMeshItem.func_190926_b()) {
            SieveMeshRegistryEntry stringMesh = new SieveMeshRegistryEntry(stringMeshItem);
            stringMesh.setMeshLevel(1);
            stringMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/string_mesh"));
            SieveMeshRegistry.add(stringMesh);
        }
        if (!(flintMeshItem = this.findItem("item_mesh", 2)).func_190926_b()) {
            SieveMeshRegistryEntry flintMesh = new SieveMeshRegistryEntry(flintMeshItem);
            flintMesh.setMeshLevel(2);
            flintMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/flint_mesh"));
            SieveMeshRegistry.add(flintMesh);
        }
        if (!(ironMeshItem = this.getNihiloItem(ExNihiloProvider.NihiloItems.IRON_MESH)).func_190926_b()) {
            SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(ironMeshItem);
            ironMesh.setMeshLevel(3);
            ironMesh.setHeavy(true);
            ironMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/iron_mesh"));
            SieveMeshRegistry.add(ironMesh);
        }
        if (!(diamondMeshItem = this.findItem("item_mesh", 4)).func_190926_b()) {
            SieveMeshRegistryEntry diamondMesh = new SieveMeshRegistryEntry(diamondMeshItem);
            diamondMesh.setMeshLevel(4);
            diamondMesh.setHeavy(true);
            diamondMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/diamond_mesh"));
            SieveMeshRegistry.add(diamondMesh);
        }
    }

    @Override
    public void postInit() {
    }

    @SubscribeEvent
    public void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ModConfig.general.disableCreatioWoodenCrucible) {
            RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(new ResourceLocation("exnihilocreatio", "crucible_wood"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (ModConfig.general.disableCreatioWoodenCrucible && event.getItemStack().func_77973_b() == this.woodenCrucible.func_77973_b()) {
            event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.excompressum:disableFakeWoodenCrucible", (Object[])new Object[0]));
        }
    }

    @Override
    public SieveModelBounds getSieveBounds() {
        return this.bounds;
    }

    @Override
    public Collection<HeavySieveReward> generateHeavyRewards(ItemStack sourceStack, int count) {
        List siftables = ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops(sourceStack);
        if (siftables != null) {
            ArrayList rewards = Lists.newArrayList();
            for (Siftable siftable : siftables) {
                if (siftable.getDrop().getItem() == null) continue;
                for (int i = 0; i < count; ++i) {
                    rewards.add(new HeavySieveReward(siftable.getDrop().getItemStack(), siftable.getChance(), siftable.getMeshLevel()));
                }
            }
            return rewards;
        }
        return Collections.emptyList();
    }

    private ItemStack findItem(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihilocreatio", name);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (item != null) {
            return new ItemStack(item, 1, withMetadata);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack findBlock(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihilocreatio", name);
        if (Block.field_149771_c.func_148741_d((Object)location)) {
            return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)location), 1, withMetadata);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNihiloItem(ExNihiloProvider.NihiloItems type) {
        ItemStack itemStack = this.itemMap.get((Object)type);
        return itemStack != null ? itemStack : ItemStack.field_190927_a;
    }

    @Override
    public boolean isHammerable(IBlockState state) {
        return ExNihiloRegistryManager.HAMMER_REGISTRY.isRegistered(state);
    }

    @Override
    public Collection<ItemStack> rollHammerRewards(IBlockState state, int miningLevel, float luck, Random rand) {
        return ExNihiloRegistryManager.HAMMER_REGISTRY.getRewardDrops(rand, state, miningLevel, (int)luck);
    }

    @Override
    public boolean isSiftable(IBlockState state) {
        List siftables = ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops((StackInfo)new BlockInfo(state));
        return siftables != null && !siftables.isEmpty();
    }

    @Override
    public boolean isSiftableWithMesh(IBlockState state, SieveMeshRegistryEntry sieveMesh) {
        List siftables = ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops((StackInfo)new BlockInfo(state));
        if (siftables != null) {
            for (Siftable siftable : siftables) {
                if (siftable.getMeshLevel() != sieveMesh.getMeshLevel()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ItemStack> rollSieveRewards(IBlockState state, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        List rewards = ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops((StackInfo)new BlockInfo(state));
        if (rewards != null) {
            ArrayList list = Lists.newArrayList();
            for (Siftable reward : rewards) {
                if (reward.getDrop().getItem() == null) continue;
                boolean meshMatches = ModConfig.general.flattenSieveRecipes ? sieveMesh.getMeshLevel() >= reward.getMeshLevel() : sieveMesh.getMeshLevel() == reward.getMeshLevel();
                int tries = rand.nextInt((int)luck + 1) + 1;
                for (int i = 0; i < tries; ++i) {
                    if (!meshMatches || !(rand.nextDouble() < (double)reward.getChance())) continue;
                    list.add(reward.getDrop().getItemStack());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ItemStack> rollCrookRewards(EntityLivingBase player, IBlockState state, float luck, Random rand) {
        List rewards = ExNihiloRegistryManager.CROOK_REGISTRY.getRewards(state);
        if (rewards != null) {
            ArrayList list = Lists.newArrayList();
            for (CrookReward reward : rewards) {
                if (!(rand.nextFloat() <= reward.getChance() + reward.getFortuneChance() * luck)) continue;
                list.add(reward.getStack().func_77946_l());
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean doMeshesHaveDurability() {
        return false;
    }

    @Override
    public boolean doMeshesSplitLootTables() {
        return true;
    }

    @Override
    public ExNihiloProvider.NihiloMod getNihiloMod() {
        return ExNihiloProvider.NihiloMod.CREATIO;
    }

    @Override
    public int getMeshFortune(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)meshStack) + EnchantmentHelper.func_77506_a((Enchantment)this.sieveFortune, (ItemStack)meshStack);
    }

    @Override
    public int getMeshEfficiency(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)meshStack) + EnchantmentHelper.func_77506_a((Enchantment)this.sieveEfficiency, (ItemStack)meshStack);
    }

    @Override
    public IBlockState getSieveRenderState() {
        Block block;
        ItemStack itemStack = this.getNihiloItem(ExNihiloProvider.NihiloItems.SIEVE);
        if (!itemStack.func_190926_b() && (block = Block.func_149634_a((Item)itemStack.func_77973_b())) instanceof BlockSieve) {
            return block.func_176223_P().func_177226_a((IProperty)BlockSieve.MESH, (Comparable)BlockSieve.MeshType.NONE);
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

