/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Random;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.config.ModConfig;

public class AutoSieveSkinRegistry {
    private static final Random random = new Random();
    private static final List<String> availableSkins = Lists.newArrayList();

    public static void load() {
        if (!ModConfig.client.skipAutoSieveSkins) {
            availableSkins.clear();
            Thread loadAutoSieveSkins = new Thread(() -> {
                try {
                    URL remoteURL = new URL("http://blay09.net/mods/control-panel/api/skins_v2.php");
                    InputStream in = remoteURL.openStream();
                    Gson gson = new Gson();
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(in));
                    JsonObject root = (JsonObject)gson.fromJson(reader, JsonObject.class);
                    if (root.has("error")) {
                        ExCompressum.logger.error("Could not load remote skins for auto sieve: {}", (Object)root.get("error").getAsString());
                        return;
                    }
                    if (root.has("skins")) {
                        JsonArray skins = root.getAsJsonArray("skins");
                        for (int i = 0; i < skins.size(); ++i) {
                            JsonObject skin = skins.get(i).getAsJsonObject();
                            List<String> list = availableSkins;
                            synchronized (list) {
                                availableSkins.add(skin.get("name").getAsString());
                                continue;
                            }
                        }
                    }
                    reader.close();
                }
                catch (Throwable e) {
                    ExCompressum.logger.error("Could not load remote skins for auto sieve: ", e);
                }
            });
            loadAutoSieveSkins.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRandomSkin() {
        List<String> list = availableSkins;
        synchronized (list) {
            if (availableSkins.isEmpty()) {
                availableSkins.add("Steve");
            }
            return availableSkins.get(random.nextInt(availableSkins.size()));
        }
    }
}

