/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.chickenstick;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.blay09.mods.excompressum.api.ReloadRegistryEvent;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ChickenStickRegistry
extends AbstractRegistry {
    public static final ChickenStickRegistry INSTANCE = new ChickenStickRegistry();
    private final List<RegistryKey> entries = Lists.newArrayList();

    public ChickenStickRegistry() {
        super("ChickenStickRegistry");
    }

    public void add(IBlockState state, boolean isWildcard) {
        this.entries.add(new RegistryKey(state, isWildcard));
    }

    public void add(ItemStack itemStack) {
        this.entries.add(new RegistryKey(itemStack));
    }

    public List<RegistryKey> getEntries() {
        return this.entries;
    }

    public static boolean isHammerable(IBlockState state) {
        RegistryKey key = new RegistryKey(state, false);
        return ChickenStickRegistry.INSTANCE.entries.contains(key) || ChickenStickRegistry.INSTANCE.entries.contains(key.withWildcard());
    }

    @Override
    public void registerDefaults(JsonObject defaults) {
        if (this.tryGetBoolean(defaults, "minecraft:cobblestone", true)) {
            this.add(Blocks.field_150347_e.func_176223_P(), false);
        }
        if (this.tryGetBoolean(defaults, "minecraft:gravel", true)) {
            this.add(Blocks.field_150351_n.func_176223_P(), false);
        }
        if (this.tryGetBoolean(defaults, "minecraft:sand", true)) {
            this.add(Blocks.field_150354_m.func_176223_P(), false);
        }
    }

    @Override
    protected ReloadRegistryEvent getRegistryEvent() {
        return new ReloadRegistryEvent.ChickenStick();
    }

    @Override
    protected void clear() {
        this.entries.clear();
    }

    @Override
    public JsonObject create() {
        JsonObject root = new JsonObject();
        JsonObject defaults = new JsonObject();
        defaults.addProperty("__comment", "You can disable defaults by setting these to false. Do *NOT* try to add additional entries here. You can add additional entries in the custom section.");
        root.add("defaults", (JsonElement)defaults);
        JsonObject custom = new JsonObject();
        custom.addProperty("__comment", "By default, the chicken stick is limited as to what it can hammer. You can define additional blocks here. Use * as a wildcard for metadata.");
        JsonObject emptyEntry = new JsonObject();
        emptyEntry.addProperty("name", "");
        emptyEntry.addProperty("metadata", "*");
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)emptyEntry);
        custom.add("entries", (JsonElement)entries);
        JsonObject example = new JsonObject();
        example.addProperty("__comment", "This example would allow smooth Stone to be hammered with the Chicken Stick.");
        example.addProperty("name", "minecraft:stone");
        example.addProperty("metadata", "0");
        custom.add("example", (JsonElement)example);
        root.add("custom", (JsonElement)custom);
        return root;
    }

    @Override
    public void loadCustom(JsonObject entry) {
        String name = this.tryGetString(entry, "name", "");
        if (name.isEmpty()) {
            return;
        }
        ResourceLocation location = new ResourceLocation(name);
        if (location.func_110624_b().equals("ore")) {
            if (!this.addOre(location.func_110623_a())) {
                this.logUnknownOre(location);
            }
        } else {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
            if (item == null) {
                this.logUnknownItem(location);
                return;
            }
            String metadata = this.tryGetString(entry, "metadata", "0");
            ItemStack itemStack = metadata.equals("*") ? new ItemStack(item, 1, Short.MAX_VALUE) : new ItemStack(item, 1, this.tryParseInt(metadata));
            this.add(itemStack);
        }
    }

    private boolean addOre(String oreName) {
        NonNullList list = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack itemStack : list) {
            this.add(itemStack);
        }
        return list.size() > 0;
    }
}

