/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressedhammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.api.ReloadRegistryEvent;
import net.blay09.mods.excompressum.api.compressedhammer.CompressedHammerRegistryEntry;
import net.blay09.mods.excompressum.api.compressedhammer.CompressedHammerReward;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class CompressedHammerRegistry
extends AbstractRegistry {
    public static final CompressedHammerRegistry INSTANCE = new CompressedHammerRegistry();
    private Map<RegistryKey, CompressedHammerRegistryEntry> entries = Maps.newHashMap();

    public CompressedHammerRegistry() {
        super("CompressedHammer");
    }

    public Map<RegistryKey, CompressedHammerRegistryEntry> getEntries() {
        return this.entries;
    }

    public void add(CompressedHammerRegistryEntry entry) {
        RegistryKey key = new RegistryKey(entry.getInputState(), entry.isWildcard());
        CompressedHammerRegistryEntry previousEntry = this.entries.get(key);
        if (previousEntry != null) {
            for (CompressedHammerReward reward : entry.getRewards()) {
                previousEntry.addReward(reward);
            }
        } else {
            this.entries.put(key, entry);
        }
    }

    @Nullable
    public static CompressedHammerRegistryEntry getEntryForBlockState(IBlockState state) {
        RegistryKey key = new RegistryKey(state, false);
        CompressedHammerRegistryEntry entry = CompressedHammerRegistry.INSTANCE.entries.get(key);
        if (entry == null) {
            return CompressedHammerRegistry.INSTANCE.entries.get(key.withWildcard());
        }
        return entry;
    }

    public static boolean isHammerable(IBlockState state) {
        return CompressedHammerRegistry.getEntryForBlockState(state) != null;
    }

    public static boolean isHammerable(ItemStack itemStack) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        return state != null && CompressedHammerRegistry.isHammerable(state);
    }

    public static Collection<ItemStack> rollHammerRewards(IBlockState state, float luck, Random rand) {
        CompressedHammerRegistryEntry entry = CompressedHammerRegistry.getEntryForBlockState(state);
        if (entry != null) {
            ArrayList list = Lists.newArrayList();
            for (CompressedHammerReward reward : entry.getRewards()) {
                float chance = reward.getBaseChance() + reward.getLuckMultiplier() * luck;
                if (!(rand.nextFloat() < chance)) continue;
                list.add(reward.getItemStack().func_77946_l());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static Collection<ItemStack> rollHammerRewards(ItemStack itemStack, float luck, Random rand) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        if (state != null) {
            return CompressedHammerRegistry.rollHammerRewards(state, luck, rand);
        }
        return Collections.emptyList();
    }

    @Override
    protected void clear() {
        this.entries.clear();
    }

    @Override
    protected JsonObject create() {
        JsonObject root = new JsonObject();
        JsonObject defaults = new JsonObject();
        defaults.addProperty("__comment", "You can disable defaults by setting these to false. Do *NOT* try to add additional entries here. You can add additional entries in the custom section.");
        root.add("defaults", (JsonElement)defaults);
        JsonObject custom = new JsonObject();
        custom.addProperty("__comment", "You can define additional blocks to be hammered by Compressed Hammers here. Use * as a wildcard for metadata. Use prefix ore: in name to query the Ore Dictionary.");
        JsonObject emptyEntry = new JsonObject();
        emptyEntry.addProperty("name", "");
        emptyEntry.addProperty("metadata", "*");
        JsonArray rewards = new JsonArray();
        JsonObject reward = new JsonObject();
        reward.addProperty("name", "");
        reward.addProperty("count", (Number)1);
        reward.addProperty("metadata", "0");
        reward.addProperty("chance", (Number)Float.valueOf(1.0f));
        reward.addProperty("luck", (Number)Float.valueOf(0.0f));
        rewards.add((JsonElement)reward);
        emptyEntry.add("rewards", (JsonElement)rewards);
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)emptyEntry);
        custom.add("entries", (JsonElement)entries);
        JsonObject example = new JsonObject();
        example.addProperty("__comment", "This example would allow Obsidian to be hammered into nine diamonds using a Compressed Hammer.");
        example.addProperty("name", "minecraft:obsidian");
        example.addProperty("metadata", "0");
        rewards = new JsonArray();
        reward = new JsonObject();
        reward.addProperty("__comment", "Chance is a floating point value (1.0 equals 100%). Luck is the multiplier that scales the hammers fortune level, applied to the base chance.");
        reward.addProperty("name", "minecraft:diamond");
        reward.addProperty("count", (Number)9);
        reward.addProperty("metadata", (Number)0);
        reward.addProperty("chance", (Number)Float.valueOf(1.0f));
        reward.addProperty("luck", (Number)Float.valueOf(0.0f));
        rewards.add((JsonElement)reward);
        example.add("rewards", (JsonElement)rewards);
        custom.add("example", (JsonElement)example);
        root.add("custom", (JsonElement)custom);
        return root;
    }

    @Override
    protected void loadCustom(JsonObject entry) {
        String name = this.tryGetString(entry, "name", "");
        if (name.isEmpty()) {
            return;
        }
        ResourceLocation location = new ResourceLocation(name);
        JsonArray rewards = this.tryGetArray(entry, "rewards");
        ArrayList rewardList = Lists.newArrayListWithCapacity((int)rewards.size());
        for (int i = 0; i < rewards.size(); ++i) {
            JsonElement element = rewards.get(i);
            if (element.isJsonObject()) {
                JsonObject reward = element.getAsJsonObject();
                String rewardName = this.tryGetString(reward, "name", "");
                if (rewardName.isEmpty()) continue;
                ResourceLocation rewardLocation = new ResourceLocation(rewardName);
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)rewardLocation);
                if (item == null) {
                    this.logUnknownItem(rewardLocation);
                    continue;
                }
                int count = this.tryGetInt(reward, "count", 1);
                int metadata = this.tryGetInt(reward, "metadata", 0);
                float chance = this.tryGetFloat(reward, "chance", 1.0f);
                if (chance > 1.0f) {
                    this.logError("Reward chance is out of range for %s in %s, capping at 1.0...", rewardLocation, this.registryName);
                    chance = 1.0f;
                }
                float luckMultiplier = this.tryGetFloat(reward, "luck", 0.0f);
                rewardList.add(new CompressedHammerReward(new ItemStack(item, count, metadata), chance, luckMultiplier));
                continue;
            }
            this.logError("Failed to preInit %s registry: rewards must be an array of json objects in ", this.registryName);
            return;
        }
        if (location.func_110624_b().equals("ore")) {
            if (!this.addOre(location.func_110623_a(), rewardList)) {
                this.logUnknownOre(location);
            }
        } else {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
            if (item == null) {
                this.logUnknownItem(location);
                return;
            }
            String metadata = this.tryGetString(entry, "metadata", "0");
            ItemStack itemStack = metadata.equals("*") ? new ItemStack(item, 1, Short.MAX_VALUE) : new ItemStack(item, 1, this.tryParseInt(metadata));
            IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
            if (state != null) {
                CompressedHammerRegistryEntry newEntry = new CompressedHammerRegistryEntry(state, itemStack.func_77952_i() == Short.MAX_VALUE);
                for (CompressedHammerReward reward : rewardList) {
                    newEntry.addReward(reward);
                }
                this.add(newEntry);
            } else {
                this.logError("Entry %s could not be registered for %s; it's not a block", location, this.registryName);
            }
        }
    }

    private boolean addOre(String oreName, List<CompressedHammerReward> rewards) {
        NonNullList list = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack itemStack : list) {
            IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
            if (state != null) {
                CompressedHammerRegistryEntry entry = new CompressedHammerRegistryEntry(state, itemStack.func_77952_i() == Short.MAX_VALUE);
                for (CompressedHammerReward reward : rewards) {
                    entry.addReward(reward);
                }
                this.add(entry);
                continue;
            }
            ExCompressum.logger.warn("Ore dictionary entry {} in {} could not be registered for {}; it's not a block", (Object)itemStack.func_77973_b().getRegistryName(), (Object)oreName, (Object)this.registryName);
        }
        return list.size() > 0;
    }

    @Override
    protected void registerDefaults(JsonObject defaults) {
        ItemStack enderGravelBlock;
        ItemStack netherGravelBlock;
        CompressedHammerRegistryEntry entry;
        ItemStack dustBlock;
        CompressedHammerRegistryEntry entry2;
        if (this.tryGetBoolean(defaults, "excompressum:compressed_cobblestone", true)) {
            entry2 = new CompressedHammerRegistryEntry(ModBlocks.compressedBlock.func_176223_P().func_177226_a(BlockCompressed.VARIANT, (Comparable)((Object)BlockCompressed.Type.COBBLESTONE)), false);
            entry2.addReward(new CompressedHammerReward(new ItemStack(Blocks.field_150351_n, 9), 1.0f, 0.0f));
            this.add(entry2);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_gravel", true)) {
            entry2 = new CompressedHammerRegistryEntry(ModBlocks.compressedBlock.func_176223_P().func_177226_a(BlockCompressed.VARIANT, (Comparable)((Object)BlockCompressed.Type.GRAVEL)), false);
            entry2.addReward(new CompressedHammerReward(new ItemStack((Block)Blocks.field_150354_m, 9), 1.0f, 0.0f));
            this.add(entry2);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_sand", true) && !(dustBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.DUST)).func_190926_b()) {
            entry = new CompressedHammerRegistryEntry(ModBlocks.compressedBlock.func_176223_P().func_177226_a(BlockCompressed.VARIANT, (Comparable)((Object)BlockCompressed.Type.SAND)), false);
            entry.addReward(new CompressedHammerReward(ItemHandlerHelper.copyStackWithSize((ItemStack)dustBlock, (int)9), 1.0f, 0.0f));
            this.add(entry);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_netherrack", true) && !(netherGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.NETHER_GRAVEL)).func_190926_b()) {
            entry = new CompressedHammerRegistryEntry(ModBlocks.compressedBlock.func_176223_P().func_177226_a(BlockCompressed.VARIANT, (Comparable)((Object)BlockCompressed.Type.NETHERRACK)), false);
            entry.addReward(new CompressedHammerReward(ItemHandlerHelper.copyStackWithSize((ItemStack)netherGravelBlock, (int)9), 1.0f, 0.0f));
            this.add(entry);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_end_stone", true) && !(enderGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.ENDER_GRAVEL)).func_190926_b()) {
            entry = new CompressedHammerRegistryEntry(ModBlocks.compressedBlock.func_176223_P().func_177226_a(BlockCompressed.VARIANT, (Comparable)((Object)BlockCompressed.Type.END_STONE)), false);
            entry.addReward(new CompressedHammerReward(ItemHandlerHelper.copyStackWithSize((ItemStack)enderGravelBlock, (int)9), 1.0f, 0.0f));
            this.add(entry);
        }
        if (Loader.isModLoaded((String)"extrautils2")) {
            CompressedHammerRegistryEntry entry3;
            Block exUtilsBlock;
            ResourceLocation location;
            CompressedHammerRegistryEntry entry4;
            Block exUtilsBlock2;
            ResourceLocation location2;
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedCobblestone", true) && Block.field_149771_c.func_148741_d((Object)(location2 = new ResourceLocation("extrautils2", "compressedcobblestone")))) {
                exUtilsBlock2 = (Block)Block.field_149771_c.func_82594_a((Object)location2);
                entry4 = new CompressedHammerRegistryEntry(exUtilsBlock2.func_176223_P(), false);
                entry4.addReward(new CompressedHammerReward(new ItemStack(Blocks.field_150351_n, 9), 1.0f, 0.0f));
                this.add(entry4);
            }
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedGravel", true) && Block.field_149771_c.func_148741_d((Object)(location2 = new ResourceLocation("extrautils2", "compressedgravel")))) {
                exUtilsBlock2 = (Block)Block.field_149771_c.func_82594_a((Object)location2);
                entry4 = new CompressedHammerRegistryEntry(exUtilsBlock2.func_176223_P(), false);
                entry4.addReward(new CompressedHammerReward(new ItemStack((Block)Blocks.field_150354_m, 9), 1.0f, 0.0f));
                this.add(entry4);
            }
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedSand", true) && !(dustBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.DUST)).func_190926_b() && Block.field_149771_c.func_148741_d((Object)(location = new ResourceLocation("extrautils2", "compressedsand")))) {
                exUtilsBlock = (Block)Block.field_149771_c.func_82594_a((Object)location);
                entry3 = new CompressedHammerRegistryEntry(exUtilsBlock.func_176223_P(), false);
                entry3.addReward(new CompressedHammerReward(ItemHandlerHelper.copyStackWithSize((ItemStack)dustBlock, (int)9), 1.0f, 0.0f));
                this.add(entry3);
            }
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedNetherrack", true) && !(netherGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.NETHER_GRAVEL)).func_190926_b() && Block.field_149771_c.func_148741_d((Object)(location = new ResourceLocation("extrautils2", "compressednetherrack")))) {
                exUtilsBlock = (Block)Block.field_149771_c.func_82594_a((Object)location);
                entry3 = new CompressedHammerRegistryEntry(exUtilsBlock.func_176223_P(), false);
                entry3.addReward(new CompressedHammerReward(ItemHandlerHelper.copyStackWithSize((ItemStack)netherGravelBlock, (int)9), 1.0f, 0.0f));
                this.add(entry3);
            }
        }
    }

    @Override
    protected ReloadRegistryEvent getRegistryEvent() {
        return new ReloadRegistryEvent.CompressedHammer();
    }
}

