/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.sievemesh;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SieveMeshRegistry {
    private static final Map<RegistryKey, SieveMeshRegistryEntry> entries = Maps.newHashMap();

    public static void registerDefaults() {
        SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(new ItemStack(ModItems.ironMesh, 1, Short.MAX_VALUE));
        ironMesh.setHeavy(true);
        ironMesh.setMeshLevel(3);
        ironMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/iron_mesh"));
        SieveMeshRegistry.add(ironMesh);
    }

    public static Map<RegistryKey, SieveMeshRegistryEntry> getEntries() {
        return entries;
    }

    @Nullable
    public static SieveMeshRegistryEntry getEntry(ItemStack itemStack) {
        RegistryKey key = new RegistryKey(itemStack);
        SieveMeshRegistryEntry entry = entries.get(key);
        if (entry == null) {
            return entries.get(key.withWildcard());
        }
        return entry;
    }

    public static void add(SieveMeshRegistryEntry sieveMesh) {
        entries.put(new RegistryKey(sieveMesh.getItemStack()), sieveMesh);
    }
}

