/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.tile.TileEntityBase;
import net.blay09.mods.excompressum.utils.DefaultItemHandler;
import net.blay09.mods.excompressum.utils.EnergyStorageModifiable;
import net.blay09.mods.excompressum.utils.ItemHandlerAutomation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

@Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyReceiver")
public class TileAutoCompressor
extends TileEntityBase
implements ITickable,
IEnergyReceiver {
    private final EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(32000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                TileAutoCompressor.this.func_70296_d();
            }
            return super.receiveEnergy(maxReceive, simulate);
        }
    };
    private final Multiset<CompressedRecipe> inputItems = HashMultiset.create();
    private final DefaultItemHandler itemHandler = new DefaultItemHandler(this, 24){

        @Override
        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot >= 12 || CompressedRecipeRegistry.getRecipe(itemStack) != null;
        }
    };
    private final RangedWrapper inputSlots = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 12);
    private final RangedWrapper outputSlots = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 12, 24);
    private final ItemHandlerAutomation itemHandlerAutomation = new ItemHandlerAutomation((IItemHandlerModifiable)this.itemHandler){

        @Override
        public boolean canInsertItem(int slot, ItemStack itemStack) {
            return slot < 12 && CompressedRecipeRegistry.getRecipe(itemStack) != null;
        }

        @Override
        public boolean canExtractItem(int slot, int amount) {
            return slot >= 12;
        }
    };
    private NonNullList<ItemStack> currentBuffer = NonNullList.func_191196_a();
    private CompressedRecipe currentRecipe = null;
    private float progress;
    private boolean isDisabledByRedstone;

    public boolean shouldCompress(Multiset<CompressedRecipe> inputItems, CompressedRecipe compressedRecipe) {
        return inputItems.count((Object)compressedRecipe) >= compressedRecipe.getCount();
    }

    public void func_73660_a() {
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.field_145850_b.field_72995_K && !this.isDisabledByRedstone() && this.getEnergyStored(null) > effectiveEnergy) {
            if (this.currentRecipe == null) {
                this.inputItems.clear();
                for (int i = 0; i < this.inputSlots.getSlots(); ++i) {
                    CompressedRecipe compressedRecipe;
                    ItemStack slotStack = this.inputSlots.getStackInSlot(i);
                    if (slotStack.func_190926_b() || (compressedRecipe = CompressedRecipeRegistry.getRecipe(slotStack)) == null) continue;
                    this.inputItems.add((Object)compressedRecipe, slotStack.func_190916_E());
                }
                for (CompressedRecipe compressedRecipe : this.inputItems.elementSet()) {
                    Ingredient ingredient = compressedRecipe.getIngredient();
                    if (!this.shouldCompress(this.inputItems, compressedRecipe)) continue;
                    int space = 0;
                    for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
                        ItemStack slotStack = this.outputSlots.getStackInSlot(i);
                        if (slotStack.func_190926_b()) {
                            space = 64;
                        } else if (this.isItemEqualWildcard(slotStack, compressedRecipe.getResultStack())) {
                            space += slotStack.func_77976_d() - slotStack.func_190916_E();
                        }
                        if (space >= compressedRecipe.getResultStack().func_190916_E()) break;
                    }
                    if (space < compressedRecipe.getResultStack().func_190916_E()) continue;
                    int count = compressedRecipe.getCount();
                    for (int i = 0; i < this.inputSlots.getSlots(); ++i) {
                        ItemStack slotStack = this.inputSlots.getStackInSlot(i);
                        if (slotStack.func_190926_b() || !ingredient.apply(slotStack)) continue;
                        if (slotStack.func_190916_E() >= count) {
                            this.currentBuffer.add((Object)slotStack.func_77979_a(count));
                            if (slotStack.func_190926_b()) {
                                this.inputSlots.setStackInSlot(i, ItemStack.field_190927_a);
                            }
                            count = 0;
                            break;
                        }
                        this.currentBuffer.add((Object)slotStack.func_77946_l());
                        count -= slotStack.func_190916_E();
                        this.inputSlots.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    if (count <= 0) {
                        this.currentRecipe = compressedRecipe;
                        this.progress = 0.0f;
                    }
                    break;
                }
            } else {
                this.energyStorage.extractEnergy(effectiveEnergy, false);
                this.progress = Math.min(1.0f, this.progress + this.getEffectiveSpeed());
                if (this.progress >= 1.0f) {
                    ItemStack resultStack;
                    CompressedRecipe compressedRecipe;
                    if (!this.field_145850_b.field_72995_K && (compressedRecipe = this.currentRecipe) != null && !this.addItemToOutput(resultStack = compressedRecipe.getResultStack().func_77946_l())) {
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, resultStack);
                        double motion = 0.05;
                        entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        entityItem.field_70181_x = 0.2;
                        entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                    this.currentBuffer.clear();
                    this.currentRecipe = null;
                    this.progress = 0.0f;
                }
            }
        }
    }

    private boolean isItemEqualWildcard(ItemStack itemStack, ItemStack otherStack) {
        return ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherStack) && (itemStack.func_77969_a(otherStack) || itemStack.func_77973_b() == otherStack.func_77973_b() && (itemStack.func_77952_i() == Short.MAX_VALUE || otherStack.func_77952_i() == Short.MAX_VALUE));
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
            ItemStack slotStack = this.outputSlots.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.func_190916_E() + itemStack.func_190916_E() > slotStack.func_77976_d() || !this.isItemEqualWildcard(slotStack, itemStack)) continue;
            slotStack.func_190917_f(itemStack.func_190916_E());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setStackInSlot(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ModConfig.automation.autoCompressorEnergy;
    }

    public float getEffectiveSpeed() {
        return ModConfig.automation.autoCompressorSpeed;
    }

    @Override
    protected boolean hasUpdatePacket() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        ItemStack itemStack;
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("CurrentRecipeResult") && !(itemStack = new ItemStack(tagCompound.func_74775_l("CurrentRecipeResult"))).func_190926_b()) {
            this.currentRecipe = new CompressedRecipe(Ingredient.field_193370_a, 0, itemStack);
        }
        this.isDisabledByRedstone = tagCompound.func_74767_n("IsDisabledByRedstone");
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        this.progress = tagCompound.func_74760_g("Progress");
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        if (tagCompound.func_74764_b("EnergyStorage")) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, tagCompound.func_74781_a("EnergyStorage"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        if (this.currentRecipe != null) {
            tagCompound.func_74782_a("CurrentRecipeResult", (NBTBase)this.currentRecipe.getResultStack().func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74757_a("IsDisabledByRedstone", this.isDisabledByRedstone);
        return super.func_189515_b(tagCompound);
    }

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        tagCompound.func_74776_a("Progress", this.progress);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        NBTBase energyStorageNBT = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (energyStorageNBT != null) {
            tagCompound.func_74782_a("EnergyStorage", energyStorageNBT);
        }
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored(null) / (float)this.getMaxEnergyStored(null);
    }

    public NonNullList<ItemStack> getCurrentBuffer() {
        return this.currentBuffer;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerAutomation;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public DefaultItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public EnergyStorageModifiable getEnergyStorage() {
        return this.energyStorage;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
    }
}

