/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.block.BlockAutoHammer;
import net.blay09.mods.excompressum.client.render.ParticleAutoHammer;
import net.blay09.mods.excompressum.compat.Compat;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.tile.TileEntityBase;
import net.blay09.mods.excompressum.utils.DefaultItemHandler;
import net.blay09.mods.excompressum.utils.EnergyStorageModifiable;
import net.blay09.mods.excompressum.utils.ItemHandlerAutomation;
import net.blay09.mods.excompressum.utils.SubItemHandler;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyReceiver")
public class TileAutoHammer
extends TileEntityBase
implements ITickable,
IEnergyReceiver {
    private static final int UPDATE_INTERVAL = 20;
    private final EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(32000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                TileAutoHammer.this.isDirty = true;
            }
            return super.receiveEnergy(maxReceive, simulate);
        }
    };
    private final DefaultItemHandler itemHandler = new DefaultItemHandler(this, 23){

        @Override
        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (slot == 0) {
                return TileAutoHammer.this.isRegistered(itemStack);
            }
            if (slot == 21 || slot == 22) {
                return TileAutoHammer.this.isHammerUpgrade(itemStack);
            }
            return true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileAutoHammer.this.hammerSlots.isInside(slot)) {
                TileAutoHammer.this.isDirty = true;
            }
        }
    };
    private final SubItemHandler inputSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 0, 1);
    private final SubItemHandler outputSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 1, 21);
    private final SubItemHandler hammerSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 21, 23);
    private final ItemHandlerAutomation itemHandlerAutomation = new ItemHandlerAutomation((IItemHandlerModifiable)this.itemHandler){

        @Override
        public boolean canExtractItem(int slot, int amount) {
            return super.canExtractItem(slot, amount) && TileAutoHammer.this.outputSlots.isInside(slot);
        }

        @Override
        public boolean canInsertItem(int slot, ItemStack itemStack) {
            return super.canInsertItem(slot, itemStack) && TileAutoHammer.this.inputSlots.isInside(slot) || TileAutoHammer.this.hammerSlots.isInside(slot);
        }
    };
    private ItemStack currentStack = ItemStack.field_190927_a;
    private int ticksSinceUpdate;
    private boolean isDirty;
    private float progress;
    private IBlockState cachedState;
    public float hammerAngle;
    private boolean isDisabledByRedstone;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int effectiveEnergy = this.getEffectiveEnergy();
            if (!this.isDisabledByRedstone() && this.getEnergyStored(null) >= effectiveEnergy) {
                if (this.currentStack.func_190926_b()) {
                    ItemStack inputStack = this.inputSlots.getStackInSlot(0);
                    if (!inputStack.func_190926_b() && this.isRegistered(inputStack)) {
                        boolean foundSpace = false;
                        for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
                            if (!this.outputSlots.getStackInSlot(i).func_190926_b()) continue;
                            foundSpace = true;
                        }
                        if (!foundSpace) {
                            return;
                        }
                        this.currentStack = inputStack.func_77979_a(1);
                        if (inputStack.func_190926_b()) {
                            this.inputSlots.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        this.energyStorage.extractEnergy(effectiveEnergy, false);
                        VanillaPacketHandler.sendTileEntityUpdate(this);
                        this.progress = 0.0f;
                    }
                } else {
                    this.energyStorage.extractEnergy(effectiveEnergy, false);
                    this.progress += this.getEffectiveSpeed();
                    this.isDirty = true;
                    if (this.progress >= 1.0f) {
                        if (!this.field_145850_b.field_72995_K) {
                            if (this.field_145850_b.field_73012_v.nextFloat() <= ModConfig.automation.autoHammerDecay) {
                                ItemStack secondHammer;
                                ItemStack firstHammer = this.hammerSlots.getStackInSlot(0);
                                if (!firstHammer.func_190926_b() && firstHammer.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                                    this.hammerSlots.setStackInSlot(0, ItemStack.field_190927_a);
                                }
                                if (!(secondHammer = this.hammerSlots.getStackInSlot(1)).func_190926_b() && secondHammer.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                                    this.hammerSlots.setStackInSlot(1, ItemStack.field_190927_a);
                                }
                            }
                            Collection<ItemStack> rewards = this.rollHammerRewards(this.currentStack, this.getMiningLevel(), this.getEffectiveLuck(), this.field_145850_b.field_73012_v);
                            for (ItemStack itemStack : rewards) {
                                if (this.addItemToOutput(itemStack)) continue;
                                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, itemStack);
                                double motion = 0.05;
                                entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                                entityItem.field_70181_x = 0.2;
                                entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                                this.field_145850_b.func_72838_d((Entity)entityItem);
                            }
                        } else {
                            this.spawnCrushParticles();
                        }
                        this.progress = 0.0f;
                        this.currentStack = ItemStack.field_190927_a;
                    }
                }
            }
            ++this.ticksSinceUpdate;
            if (this.ticksSinceUpdate > 20) {
                if (this.isDirty) {
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.isDirty = false;
                }
                this.ticksSinceUpdate = 0;
            }
        }
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
            ItemStack slotStack = this.outputSlots.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.func_190916_E() + itemStack.func_190916_E() > slotStack.func_77976_d() || !slotStack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            slotStack.func_190917_f(itemStack.func_190916_E());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setStackInSlot(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ModConfig.automation.autoHammerEnergy;
    }

    public float getSpeedMultiplier() {
        ItemStack secondHammer;
        float HAMMER_BOOST = 0.5f;
        float EFFICIENCY_BOOST = 0.5f;
        float boost = 1.0f;
        ItemStack firstHammer = this.hammerSlots.getStackInSlot(0);
        if (!firstHammer.func_190926_b() && this.isHammerUpgrade(firstHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.getStackInSlot(1)).func_190926_b() && this.isHammerUpgrade(secondHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)secondHammer);
        }
        return boost;
    }

    public float getEffectiveSpeed() {
        return ModConfig.automation.autoHammerSpeed * this.getSpeedMultiplier();
    }

    public float getEffectiveLuck() {
        ItemStack secondHammer;
        float luck = 0.0f;
        ItemStack firstHammer = this.hammerSlots.getStackInSlot(0);
        if (!firstHammer.func_190926_b() && this.isHammerUpgrade(firstHammer)) {
            luck += (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.getStackInSlot(1)).func_190926_b() && this.isHammerUpgrade(secondHammer)) {
            luck += (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)secondHammer);
        }
        return luck;
    }

    @Override
    protected boolean hasUpdatePacket() {
        return true;
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        this.currentStack = new ItemStack(tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
        if (tagCompound.func_74764_b("EnergyStorage")) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, tagCompound.func_74781_a("EnergyStorage"));
        }
        if (isSync) {
            this.hammerSlots.setStackInSlot(0, new ItemStack(tagCompound.func_74775_l("FirstHammer")));
            this.hammerSlots.setStackInSlot(1, new ItemStack(tagCompound.func_74775_l("SecondHammer")));
        } else {
            this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        }
        this.isDisabledByRedstone = tagCompound.func_74767_n("IsDisabledByRedstone");
    }

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        NBTBase energyStorageNBT = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (energyStorageNBT != null) {
            tagCompound.func_74782_a("EnergyStorage", energyStorageNBT);
        }
        tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74776_a("Progress", this.progress);
        if (isSync) {
            ItemStack firstHammer = this.hammerSlots.getStackInSlot(0);
            tagCompound.func_74782_a("FirstHammer", (NBTBase)firstHammer.func_77955_b(new NBTTagCompound()));
            ItemStack secondHammer = this.hammerSlots.getStackInSlot(1);
            tagCompound.func_74782_a("SecondHammer", (NBTBase)secondHammer.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        }
        tagCompound.func_74757_a("IsDisabledByRedstone", this.isDisabledByRedstone);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCrushParticles() {
        IBlockState currentBlock;
        if (!ModConfig.client.disableParticles && !this.isUgly() && (currentBlock = this.getCurrentBlock()) != null) {
            for (int i = 0; i < 10; ++i) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleAutoHammer(this.field_145850_b, this.field_174879_c, (float)this.field_174879_c.func_177958_n() + 0.7f, (float)this.field_174879_c.func_177956_o() + 0.3f, (float)this.field_174879_c.func_177952_p() + 0.5f, (-this.field_145850_b.field_73012_v.nextDouble() + (double)0.2f) / 9.0, 0.2f, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) / 9.0, currentBlock));
            }
        }
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored(null) / (float)this.getMaxEnergyStored(null);
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    @Nullable
    public IBlockState getCurrentBlock() {
        if (this.currentStack.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)this.currentStack.func_77973_b());
        if (block != Blocks.field_150350_a) {
            return block.func_176203_a(this.currentStack.func_77960_j());
        }
        return null;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerAutomation;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public DefaultItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemStack getUpgradeStack(int i) {
        return this.hammerSlots.getStackInSlot(i);
    }

    public boolean isHammerUpgrade(ItemStack itemStack) {
        NBTTagCompound tagCompound;
        if (itemStack.func_77973_b() == Compat.TCONSTRUCT_HAMMER && (tagCompound = itemStack.func_77978_p()) != null) {
            NBTTagList traits = tagCompound.func_150295_c("Traits", 8);
            for (NBTBase tag : traits) {
                if (!((NBTTagString)tag).func_150285_a_().equalsIgnoreCase("exnihilo_smashing")) continue;
                return true;
            }
        }
        return ExRegistro.isNihiloItem(itemStack, ExNihiloProvider.NihiloItems.HAMMER_DIAMOND);
    }

    public boolean isRegistered(ItemStack itemStack) {
        return ExRegistro.isHammerable(itemStack);
    }

    public Collection<ItemStack> rollHammerRewards(ItemStack itemStack, int miningLevel, float luck, Random rand) {
        return ExRegistro.rollHammerRewards(itemStack, miningLevel, luck, rand);
    }

    public int getMiningLevel() {
        return Item.ToolMaterial.DIAMOND.func_77996_d();
    }

    public boolean shouldAnimate() {
        return !this.currentStack.func_190926_b() && this.getEnergyStored(null) >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    public EnergyStorageModifiable getEnergyStorage() {
        return this.energyStorage;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        this.cachedState = null;
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isUgly() {
        if (this.cachedState == null) {
            this.cachedState = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        if (this.cachedState.func_177230_c() instanceof BlockAutoHammer) {
            return (Boolean)this.cachedState.func_177229_b((IProperty)BlockAutoHammer.UGLY);
        }
        return false;
    }

    public EnumFacing getFacing() {
        if (this.cachedState == null) {
            this.cachedState = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        if (this.cachedState.func_177230_c() instanceof BlockAutoHammer) {
            return (EnumFacing)this.cachedState.func_177229_b((IProperty)BlockAutoHammer.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceUpdate = 20;
    }
}

