/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.BlockAutoSieveBase;
import net.blay09.mods.excompressum.client.render.ParticleSieve;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.tile.TileEntityBase;
import net.blay09.mods.excompressum.utils.DefaultItemHandler;
import net.blay09.mods.excompressum.utils.ItemHandlerAutomation;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.blay09.mods.excompressum.utils.SubItemHandler;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileAutoSieveBase
extends TileEntityBase
implements ITickable {
    private static final int UPDATE_INTERVAL = 20;
    private static final int PARTICLE_TICKS = 30;
    private final DefaultItemHandler itemHandler = new DefaultItemHandler(this, 22){

        @Override
        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (TileAutoSieveBase.this.inputSlots.isInside(slot)) {
                return TileAutoSieveBase.this.isSiftable(itemStack);
            }
            if (TileAutoSieveBase.this.meshSlots.isInside(slot)) {
                return TileAutoSieveBase.this.isMesh(itemStack);
            }
            return true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileAutoSieveBase.this.meshSlots.isInside(slot)) {
                TileAutoSieveBase.this.isDirty = true;
            }
        }
    };
    private final SubItemHandler inputSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 0, 1);
    private final SubItemHandler outputSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 1, 21);
    private final SubItemHandler meshSlots = new SubItemHandler((IItemHandlerModifiable)this.itemHandler, 21, 22);
    private final ItemHandlerAutomation itemHandlerAutomation = new ItemHandlerAutomation((IItemHandlerModifiable)this.itemHandler){

        @Override
        public boolean canExtractItem(int slot, int amount) {
            return super.canExtractItem(slot, amount) && TileAutoSieveBase.this.outputSlots.isInside(slot);
        }

        @Override
        public boolean canInsertItem(int slot, ItemStack itemStack) {
            return super.canInsertItem(slot, itemStack) && (TileAutoSieveBase.this.inputSlots.isInside(slot) || TileAutoSieveBase.this.meshSlots.isInside(slot));
        }
    };
    private ItemStack currentStack = ItemStack.field_190927_a;
    private GameProfile customSkin;
    private int ticksSinceSync;
    protected boolean isDirty;
    private float progress;
    private float foodBoost;
    private int foodBoostTicks;
    private IBlockState cachedState;
    public float armAngle;
    private int particleTicks;
    private int particleCount;
    private boolean isDisabledByRedstone;

    public void func_73660_a() {
        if (this.foodBoostTicks > 0) {
            --this.foodBoostTicks;
            if (this.foodBoostTicks <= 0) {
                this.foodBoost = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksSinceSync;
            if (this.ticksSinceSync > 20) {
                if (this.isDirty) {
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.isDirty = false;
                }
                this.ticksSinceSync = 0;
            }
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.getEnergyStored(null) >= effectiveEnergy) {
            if (this.currentStack.func_190926_b()) {
                ItemStack inputStack = this.inputSlots.getStackInSlot(0);
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (!inputStack.func_190926_b() && sieveMesh != null && this.isSiftableWithMesh(inputStack, sieveMesh)) {
                    boolean foundSpace = false;
                    for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
                        if (!this.outputSlots.getStackInSlot(i).func_190926_b()) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = inputStack.func_77979_a(1);
                    if (inputStack.func_190926_b()) {
                        this.inputSlots.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.extractEnergy(effectiveEnergy, false);
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.progress = 0.0f;
                }
            } else {
                this.extractEnergy(effectiveEnergy, false);
                if (this.getEffectiveSpeed() < 0.0f) {
                    System.out.println("WUT");
                }
                this.progress += this.getEffectiveSpeed();
                this.particleTicks = 30;
                this.particleCount = (int)this.getSpeedMultiplier();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (!this.field_145850_b.field_72995_K) {
                        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                        if (sieveMesh != null) {
                            ItemStack meshStack;
                            Collection<ItemStack> rewards = this.rollSieveRewards(this.currentStack, sieveMesh, this.getEffectiveLuck(), this.field_145850_b.field_73012_v);
                            for (ItemStack itemStack : rewards) {
                                if (this.addItemToOutput(itemStack)) continue;
                                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, itemStack));
                            }
                            if (ExRegistro.doMeshesHaveDurability() && !(meshStack = this.meshSlots.getStackInSlot(0)).func_190926_b() && meshStack.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.5f, 2.5f);
                                meshStack.func_190918_g(1);
                                this.meshSlots.setStackInSlot(0, ItemStack.field_190927_a);
                            }
                        } else if (!this.addItemToOutput(this.currentStack)) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.currentStack));
                        }
                    }
                    this.progress = 0.0f;
                    this.currentStack = ItemStack.field_190927_a;
                }
            }
        }
        if (this.particleTicks > 0 && this.field_145850_b.field_72995_K) {
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            this.spawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (this.currentStack.func_190926_b() || ModConfig.client.disableParticles || this.isUgly()) {
            return;
        }
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (particleSetting == 2) {
            return;
        }
        int actualParticleCount = this.particleCount;
        if (particleSetting == 1) {
            float half = (float)actualParticleCount / 2.0f;
            if (half < 1.0f && Math.random() <= 0.5) {
                return;
            }
            actualParticleCount = (int)Math.ceil(half);
        }
        int metadata = this.func_145832_p();
        IBlockState state = StupidUtils.getStateFromItemStack(this.currentStack);
        if (state != null) {
            for (int i = 0; i < actualParticleCount; ++i) {
                double particleX = 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.4 - 0.2;
                double particleZ = 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.4 - 0.2;
                switch (EnumFacing.func_82600_a((int)metadata)) {
                    case WEST: {
                        particleZ -= 0.125;
                        break;
                    }
                    case EAST: {
                        particleZ += 0.125;
                        break;
                    }
                    case NORTH: {
                        particleX += 0.125;
                        break;
                    }
                    case SOUTH: {
                        particleX -= 0.125;
                        break;
                    }
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSieve(this.field_145850_b, this.field_174879_c, particleX, 0.2, particleZ, 0.5f, state));
            }
        }
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
            ItemStack slotStack = this.outputSlots.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.func_190916_E() + itemStack.func_190916_E() > slotStack.func_77976_d() || !slotStack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            slotStack.func_190917_f(itemStack.func_190916_E());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setStackInSlot(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ModConfig.automation.autoSieveEnergy;
    }

    public float getEffectiveSpeed() {
        return ModConfig.automation.autoSieveSpeed * this.getSpeedMultiplier();
    }

    public float getEffectiveLuck() {
        ItemStack meshStack = this.meshSlots.getStackInSlot(0);
        if (!meshStack.func_190926_b()) {
            return ExRegistro.getMeshFortune(meshStack);
        }
        return 0.0f;
    }

    public boolean isSiftable(ItemStack itemStack) {
        return ExRegistro.isSiftable(itemStack);
    }

    public boolean isSiftableWithMesh(ItemStack itemStack, SieveMeshRegistryEntry sieveMesh) {
        return ExRegistro.isSiftableWithMesh(itemStack, sieveMesh);
    }

    public boolean isMesh(ItemStack itemStack) {
        return SieveMeshRegistry.getEntry(itemStack) != null;
    }

    public Collection<ItemStack> rollSieveRewards(ItemStack itemStack, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        return ExRegistro.rollSieveRewards(itemStack, sieveMesh, luck, rand);
    }

    @Override
    protected boolean hasUpdatePacket() {
        return true;
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        this.currentStack = new ItemStack(tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
        if (tagCompound.func_74764_b("CustomSkin")) {
            this.customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"));
            if (this.customSkin != null) {
                ExCompressum.proxy.preloadSkin(this.customSkin);
            }
        }
        this.foodBoost = tagCompound.func_74760_g("FoodBoost");
        this.foodBoostTicks = tagCompound.func_74762_e("FoodBoostTicks");
        this.particleTicks = tagCompound.func_74762_e("ParticleTicks");
        this.particleCount = tagCompound.func_74762_e("ParticleCount");
        if (isSync) {
            this.meshSlots.setStackInSlot(0, new ItemStack(tagCompound.func_74775_l("MeshStack")));
        } else {
            this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        }
        this.isDisabledByRedstone = tagCompound.func_74767_n("IsDisabledByRedstone");
    }

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74776_a("Progress", this.progress);
        if (this.customSkin != null) {
            NBTTagCompound customSkinTag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)customSkinTag, (GameProfile)this.customSkin);
            tagCompound.func_74782_a("CustomSkin", (NBTBase)customSkinTag);
        }
        tagCompound.func_74776_a("FoodBoost", this.foodBoost);
        tagCompound.func_74768_a("FoodBoostTicks", this.foodBoostTicks);
        tagCompound.func_74768_a("ParticleTicks", this.particleTicks);
        tagCompound.func_74768_a("ParticleCount", this.particleCount);
        if (isSync) {
            ItemStack meshStack = this.meshSlots.getStackInSlot(0);
            tagCompound.func_74782_a("MeshStack", (NBTBase)meshStack.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        }
        tagCompound.func_74757_a("IsDisabledByRedstone", this.isDisabledByRedstone());
    }

    public abstract int getMaxEnergyStored();

    public abstract int getEnergyStored(@Nullable EnumFacing var1);

    public abstract int extractEnergy(int var1, boolean var2);

    public abstract void setEnergyStored(int var1);

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored(null) / (float)this.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public void setCustomSkin(GameProfile customSkin) {
        this.customSkin = customSkin;
        this.grabProfile();
        this.isDirty = true;
        this.func_70296_d();
    }

    @Nullable
    public GameProfile getCustomSkin() {
        return this.customSkin;
    }

    private void grabProfile() {
        new Thread(() -> {
            try {
                GameProfile gameProfile;
                if (!(this.field_145850_b.field_72995_K || this.customSkin == null || StringUtils.func_151246_b((String)this.customSkin.getName()) || this.customSkin.isComplete() && this.customSkin.getProperties().containsKey((Object)"textures") || (gameProfile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(this.customSkin.getName())) == null)) {
                    Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                    if (property == null) {
                        gameProfile = FMLCommonHandler.instance().getMinecraftServerInstance().func_147130_as().fillProfileProperties(gameProfile, true);
                    }
                    this.customSkin = gameProfile;
                    this.isDirty = true;
                    this.func_70296_d();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }).start();
    }

    public float getSpeedMultiplier() {
        float EFFICIENCY_BOOST = 0.25f;
        float boost = 1.0f;
        ItemStack meshStack = this.meshSlots.getStackInSlot(0);
        if (!meshStack.func_190926_b()) {
            boost += 0.25f * (float)ExRegistro.getMeshEfficiency(meshStack);
        }
        return boost * this.getFoodBoost();
    }

    public float getFoodBoost() {
        return 1.0f + this.foodBoost;
    }

    public void setFoodBoost(int foodBoostTicks, float foodBoost) {
        this.foodBoostTicks = foodBoostTicks;
        this.foodBoost = foodBoost;
        this.isDirty = true;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerAutomation;
        }
        return (T)super.getCapability(capability, facing);
    }

    public DefaultItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        ItemStack meshStack = this.meshSlots.getStackInSlot(0);
        if (!meshStack.func_190926_b()) {
            return SieveMeshRegistry.getEntry(meshStack);
        }
        return null;
    }

    public ItemStack getMeshStack() {
        return this.meshSlots.getStackInSlot(0);
    }

    public boolean isCorrectSieveMesh() {
        ItemStack inputStack = this.inputSlots.getStackInSlot(0);
        SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
        return inputStack.func_190926_b() || sieveMesh == null || this.isSiftableWithMesh(inputStack, sieveMesh);
    }

    public boolean shouldAnimate() {
        return !this.currentStack.func_190926_b() && this.getEnergyStored(null) >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        this.cachedState = null;
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isUgly() {
        if (this.cachedState == null) {
            this.cachedState = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        if (this.cachedState.func_177230_c() instanceof BlockAutoSieveBase) {
            return (Boolean)this.cachedState.func_177229_b((IProperty)BlockAutoSieveBase.UGLY);
        }
        return false;
    }

    public EnumFacing getFacing() {
        if (this.cachedState == null) {
            this.cachedState = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        if (this.cachedState.func_177230_c() instanceof BlockAutoSieveBase) {
            return (EnumFacing)this.cachedState.func_177229_b((IProperty)BlockAutoSieveBase.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceSync = 20;
    }
}

