/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import java.util.Collection;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.client.render.ParticleSieve;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileHeavySieve
extends TileEntity
implements ITickable {
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 5;
    private static final int PARTICLE_TICKS = 20;
    private static final float EFFICIENCY_BOOST = 0.25f;
    private ItemStack meshStack = ItemStack.field_190927_a;
    private ItemStack currentStack = ItemStack.field_190927_a;
    private float progress;
    private int clicksSinceSecond;
    private boolean isDirty;
    private int ticksSinceSync;
    private int ticksSinceSecond;
    private int particleTicks;
    private int particleCount;

    public boolean addSiftable(EntityPlayer player, ItemStack itemStack) {
        if (!this.currentStack.func_190926_b() || this.meshStack.func_190926_b() || !HeavySieveRegistry.isSiftable(itemStack)) {
            return false;
        }
        this.currentStack = player.field_71075_bZ.field_75098_d ? ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1) : itemStack.func_77979_a(1);
        this.progress = 0.0f;
        VanillaPacketHandler.sendTileEntityUpdate(this);
        return true;
    }

    public void func_73660_a() {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 5) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
        }
        ++this.ticksSinceSecond;
        if (this.ticksSinceSecond >= 20) {
            this.clicksSinceSecond = 0;
            this.ticksSinceSecond = 0;
        }
        if (this.particleTicks > 0) {
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                this.spawnParticles();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        IBlockState state;
        if (this.currentStack.func_190926_b() || ModConfig.client.disableParticles) {
            return;
        }
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (particleSetting == 2) {
            return;
        }
        int actualParticleCount = this.particleCount;
        if (particleSetting == 1) {
            float half = (float)actualParticleCount / 2.0f;
            if (half < 1.0f && Math.random() <= 0.5) {
                return;
            }
            actualParticleCount = (int)Math.ceil(half);
        }
        if ((state = StupidUtils.getStateFromItemStack(this.currentStack)) != null) {
            for (int i = 0; i < actualParticleCount; ++i) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSieve(this.field_145850_b, this.field_174879_c, 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.8 - 0.4, 0.4, 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.8 - 0.4, 1.0f, state));
            }
        }
    }

    public boolean processContents(EntityPlayer player) {
        if (!this.currentStack.func_190926_b() && !this.meshStack.func_190926_b()) {
            if (player.field_71075_bZ.field_75098_d) {
                this.progress = 1.0f;
            } else {
                ++this.clicksSinceSecond;
                if (this.clicksSinceSecond <= ModConfig.automation.heavySieveClicksPerSecond) {
                    int efficiency = ExRegistro.getMeshEfficiency(this.meshStack);
                    this.progress = Math.min(1.0f, this.progress + 0.075f * (1.0f + (float)efficiency * 0.25f));
                }
            }
            if (this.progress >= 1.0f) {
                this.particleCount = 0;
                if (!this.field_145850_b.field_72995_K) {
                    SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                    if (sieveMesh != null) {
                        int fortune = ExRegistro.getMeshFortune(this.meshStack);
                        fortune = (int)((float)fortune + player.func_184817_da());
                        Collection<ItemStack> rewards = HeavySieveRegistry.rollSieveRewards(this.currentStack, sieveMesh, (float)fortune, this.field_145850_b.field_73012_v);
                        for (ItemStack itemStack : rewards) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, itemStack));
                        }
                    } else {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.currentStack));
                    }
                    this.currentStack = ItemStack.field_190927_a;
                    if (ExRegistro.doMeshesHaveDurability() && sieveMesh != null) {
                        if (!sieveMesh.isHeavy()) {
                            this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.5f, 2.5f);
                            this.meshStack = ItemStack.field_190927_a;
                        } else {
                            this.meshStack.func_77972_a(1, (EntityLivingBase)player);
                            if (this.meshStack.func_190926_b()) {
                                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.5f, 2.5f);
                                this.meshStack = ItemStack.field_190927_a;
                            }
                        }
                    }
                    this.progress = 0.0f;
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                }
            }
            this.particleTicks = 20;
            ++this.particleCount;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.currentStack = new ItemStack(tagCompound.func_74775_l("Content"));
        this.meshStack = new ItemStack(tagCompound.func_74775_l("Mesh"));
        this.progress = tagCompound.func_74760_g("Progress");
        this.particleTicks = tagCompound.func_74762_e("ParticleTicks");
        this.particleCount = tagCompound.func_74762_e("ParticleCount");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("Content", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74782_a("Mesh", (NBTBase)this.meshStack.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74776_a("Progress", this.progress);
        tagCompound.func_74768_a("ParticleTicks", this.particleTicks);
        tagCompound.func_74768_a("ParticleCount", this.particleCount);
        return tagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public ItemStack getMeshStack() {
        return this.meshStack;
    }

    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        if (!this.meshStack.func_190926_b()) {
            return SieveMeshRegistry.getEntry(this.meshStack);
        }
        return null;
    }

    public void setMeshStack(ItemStack meshStack) {
        this.meshStack = meshStack;
        VanillaPacketHandler.sendTileEntityUpdate(this);
    }
}

