/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.block.abstracts;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.GenericUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractBlockValve
extends Block {
    protected AbstractBlockValve(String name) {
        super(Material.field_151573_f);
        this.func_149663_c("ffs." + name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setDefaultState();
    }

    protected abstract void setDefaultState();

    public abstract BlockStateContainer func_180661_e();

    public abstract IBlockState func_176221_a(IBlockState var1, IBlockAccess var2, BlockPos var3);

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        AbstractTankValve valve;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof AbstractTankValve && (valve = (AbstractTankValve)tile).isValid() && valve.getTankConfig().getFluidStack() != null) {
            return 20.0f;
        }
        return 5.0f;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        AbstractTankValve valve;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTankValve && (valve = (AbstractTankValve)world.func_175625_s(pos)) != null && valve.isValid()) {
            valve.breakTank();
        }
        super.func_180652_a(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        AbstractTankValve valve;
        if (!world.field_72995_K && (valve = (AbstractTankValve)world.func_175625_s(pos)) != null && valve.isValid()) {
            valve.breakTank();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        AbstractTankValve valve;
        if (!world.field_72995_K && (valve = (AbstractTankValve)world.func_175625_s(pos)) != null && valve.isValid()) {
            valve.breakTank();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        AbstractTankValve valve = (AbstractTankValve)world.func_175625_s(pos);
        if (valve == null) {
            return true;
        }
        if (valve.isValid()) {
            if (GenericUtil.isFluidContainer(player.func_184614_ca()) && GenericUtil.fluidContainerHandler(world, valve, player)) {
                valve.markForUpdateNow();
                return true;
            }
            player.openGui((Object)FancyFluidStorage.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        valve.buildTank_player(player, facing.func_176734_d());
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof AbstractTankValve) {
            AbstractTankValve valve = (AbstractTankValve)te;
            return valve.getComparatorOutput();
        }
        return 0;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }
}

