/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.block.tanktiles;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.client.CreativeTabFFS;
import com.lordmau5.ffs.tile.abstracts.AbstractTankTile;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.tile.tanktiles.TileEntityTankComputer;
import com.lordmau5.ffs.util.FFSStateProps;
import com.lordmau5.ffs.util.GenericUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTankComputer
extends Block {
    public BlockTankComputer() {
        super(Material.field_151573_f);
        this.func_149663_c("ffs.block_tank_computer");
        this.setRegistryName("block_tank_computer");
        this.func_149647_a(CreativeTabFFS.INSTANCE);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FFSStateProps.TILE_VALID, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTankComputer();
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof AbstractTankTile && ((AbstractTankTile)tile).getMasterValve() != null) {
            ((AbstractTankTile)tile).getMasterValve().breakTank();
        }
        super.func_180652_a(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof AbstractTankTile && ((AbstractTankTile)tile).getMasterValve() != null) {
            ((AbstractTankTile)tile).getMasterValve().breakTank();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        AbstractTankTile tile = (AbstractTankTile)world.func_175625_s(pos);
        if (tile != null && tile.getMasterValve() != null) {
            AbstractTankValve valve = tile.getMasterValve();
            if (GenericUtil.isFluidContainer(player.func_184614_ca())) {
                return GenericUtil.fluidContainerHandler(world, valve, player);
            }
            player.openGui((Object)FancyFluidStorage.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FFSStateProps.TILE_VALID});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityTankComputer) {
            TileEntityTankComputer valve = (TileEntityTankComputer)tile;
            state = state.func_177226_a((IProperty)FFSStateProps.TILE_VALID, (Comparable)Boolean.valueOf(valve.isValid()));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState otherState = worldIn.func_180495_p(pos.func_177972_a(side));
        return otherState != this.func_176194_O();
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }
}

