/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.client;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.config.ModConfig;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.ClientRenderHelper;
import com.lordmau5.ffs.util.LayerBlockPos;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;

public class ValveRenderer
extends FastTESR<AbstractTankValve> {
    private void preGL() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
    }

    private void postGL() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(AbstractTankValve te) {
        return true;
    }

    public void renderTileEntityFast(@Nonnull AbstractTankValve valve, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nonnull BufferBuilder vb) {
        if (valve == null || !valve.isValid() || !valve.isMaster()) {
            return;
        }
        if (valve.getTankConfig().getFluidCapacity() == 0 || valve.getTankConfig().getFluidAmount() == 0) {
            return;
        }
        BlockPos valvePos = valve.func_174877_v();
        float fillPercentage = (float)valve.getTankConfig().getFluidAmount() / (float)valve.getTankConfig().getFluidCapacity();
        if (fillPercentage > 0.0f && valve.getTankConfig().getFluidStack() != null) {
            FluidStack fluid = valve.getTankConfig().getFluidStack();
            vb.func_178969_c(x, y, z);
            TreeMap<Integer, List<LayerBlockPos>> airBlocks = FancyFluidStorage.tankManager.getAirBlocksForValve(valve);
            if (airBlocks == null || airBlocks.isEmpty()) {
                return;
            }
            TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
            TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
            this.preGL();
            if (fluid.getFluid().isGaseous()) {
                this.renderGasTank(still, flowing, airBlocks, valve, valvePos, vb, fluid, fillPercentage);
            } else {
                this.renderFluidTank(still, flowing, airBlocks, valve, valvePos, vb, fluid);
            }
            this.postGL();
        }
    }

    private void renderGasTank(TextureAtlasSprite still, TextureAtlasSprite flowing, TreeMap<Integer, List<LayerBlockPos>> airBlocks, AbstractTankValve valve, BlockPos valvePos, BufferBuilder vb, FluidStack fluid, float fillPercentage) {
        int color = ClientRenderHelper.changeAlpha(fluid.getFluid().getColor(), (int)(fillPercentage * 255.0f));
        ArrayList<Integer> layers = new ArrayList<Integer>(airBlocks.keySet());
        int topLayer = (Integer)layers.get(layers.size() - 1) - 1;
        for (Integer layer : airBlocks.keySet()) {
            for (LayerBlockPos pos : airBlocks.get(layer)) {
                BlockPos fromPos = pos.func_177973_b((Vec3i)valvePos);
                this.renderFluidBlock(still, flowing, vb, fluid, pos, fromPos, color, (double)fromPos.func_177958_n() + 1.0, (double)fromPos.func_177956_o() + 1.0, (double)fromPos.func_177952_p() + 1.0, layer == topLayer);
            }
        }
    }

    private void renderFluidTank(TextureAtlasSprite still, TextureAtlasSprite flowing, TreeMap<Integer, List<LayerBlockPos>> airBlocks, AbstractTankValve valve, BlockPos valvePos, BufferBuilder vb, FluidStack fluid) {
        ArrayList<Integer> layers = new ArrayList<Integer>(airBlocks.keySet());
        ArrayList<Double> fillLevels = new ArrayList<Double>();
        double fluidLeft = valve.getTankConfig().getFluidAmount();
        for (Integer layer : layers) {
            int layerBlockSize;
            if (fluidLeft <= 0.0 || (layerBlockSize = airBlocks.get(layer).size()) == 0) continue;
            double layerCapacity = (double)ModConfig.general.mbPerTankBlock * (double)layerBlockSize;
            fillLevels.add(Math.min(1.0, fluidLeft / layerCapacity));
            fluidLeft -= layerCapacity;
        }
        for (int i = 0; i < fillLevels.size(); ++i) {
            int layer = (Integer)layers.get(i) + 1;
            double currentLayerHeight = (Double)fillLevels.get(i);
            for (LayerBlockPos pos : airBlocks.get(layer)) {
                BlockPos fromPos = pos.func_177973_b((Vec3i)valvePos);
                this.renderFluidBlock(still, flowing, vb, fluid, pos, fromPos, fluid.getFluid().getColor(fluid), (double)fromPos.func_177958_n() + 1.0, (double)fromPos.func_177956_o() + currentLayerHeight, (double)fromPos.func_177952_p() + 1.0, i == fillLevels.size() - 1);
            }
        }
    }

    private void renderFluidBlock(TextureAtlasSprite still, TextureAtlasSprite flowing, BufferBuilder vb, FluidStack fluid, BlockPos pos, BlockPos from, int color, double x2, double y2, double z2, boolean isTop) {
        int brightness = this.func_178459_a().func_175626_b(pos, fluid.getFluid().getLuminosity());
        double x1 = from.func_177958_n();
        double y1 = from.func_177956_o();
        double z1 = from.func_177952_p();
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos currentOffset = pos.func_177972_a(facing);
            if ((facing != EnumFacing.UP || !isTop) && (this.func_178459_a().func_180495_p(currentOffset).func_185914_p() || this.func_178459_a().func_175623_d(currentOffset))) continue;
            ClientRenderHelper.putTexturedQuad(vb, facing != EnumFacing.DOWN && facing != EnumFacing.UP ? flowing : still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, facing, color, brightness, facing != EnumFacing.DOWN && facing != EnumFacing.UP);
        }
    }
}

