/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.client.gui;

import com.lordmau5.ffs.client.gui.GuiButtonLockFluid;
import com.lordmau5.ffs.network.FFSPacket;
import com.lordmau5.ffs.network.NetworkHandler;
import com.lordmau5.ffs.tile.abstracts.AbstractTankTile;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.tile.interfaces.INameableTile;
import com.lordmau5.ffs.util.ClientRenderHelper;
import com.lordmau5.ffs.util.GenericUtil;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiValve
extends GuiScreen {
    private static final ResourceLocation tex_valve = new ResourceLocation("ffs:textures/gui/gui_tank_valve.png");
    private static final ResourceLocation tex_no_valve = new ResourceLocation("ffs:textures/gui/gui_tank_no_valve.png");
    private final AbstractTankValve valve;
    private final AbstractTankValve masterValve;
    private final int xSize_Valve = 196;
    private final int ySize_Valve = 128;
    private final int xSize_NoValve = 96;
    private final int ySize_NoValve = 128;
    private GuiButtonLockFluid lockFluidButton;
    private boolean isNonValve = false;
    private AbstractTankTile tile;
    private GuiTextField tileName;
    private int left = 0;
    private int top = 0;
    private int mouseX;
    private int mouseY;

    public GuiValve(AbstractTankTile tile, boolean isNonValve) {
        this.isNonValve = isNonValve;
        if (!isNonValve) {
            this.tile = tile;
            this.valve = tile instanceof AbstractTankValve ? (AbstractTankValve)tile : tile.getMasterValve();
            this.masterValve = tile.getMasterValve();
        } else {
            this.valve = this.masterValve = tile.getMasterValve();
        }
    }

    private void initGuiValve() {
        this.left = (this.field_146294_l - this.xSize_Valve) / 2;
        ((Object)((Object)this)).getClass();
        this.top = (this.field_146295_m - 128) / 2;
        if (this.tile instanceof INameableTile) {
            this.tileName = new GuiTextField(0, this.field_146289_q, this.left + 90, this.top + 102, 82, 10);
            this.tileName.func_146180_a(this.valve.getTileName());
            this.tileName.func_146203_f(32);
        }
        this.lockFluidButton = new GuiButtonLockFluid(this.left + 62, this.top + 26, this.masterValve.getTankConfig().isFluidLocked());
        this.field_146292_n.add(this.lockFluidButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.isNonValve) {
            this.left = (this.field_146294_l - this.xSize_NoValve) / 2;
            ((Object)((Object)this)).getClass();
            this.top = (this.field_146295_m - 128) / 2;
            this.lockFluidButton = new GuiButtonLockFluid(this.left + 66, this.top + 26, this.masterValve.getTankConfig().isFluidLocked());
            this.field_146292_n.add(this.lockFluidButton);
        } else {
            this.initGuiValve();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.tile instanceof INameableTile && !this.tileName.func_146179_b().isEmpty()) {
            NetworkHandler.sendPacketToServer(new FFSPacket.Server.UpdateTileName(this.tile, this.tileName.func_146179_b()));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (this.tile instanceof INameableTile && this.tileName.func_146206_l()) {
            this.tileName.func_146201_a(keyChar, keyCode);
            return;
        }
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) throws IOException {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        if (this.tile instanceof INameableTile) {
            this.tileName.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawGUIValve(int x, int y, float partialTicks) {
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(tex_valve);
        ((Object)((Object)this)).getClass();
        this.func_73729_b(this.left, this.top, 0, 0, this.xSize_Valve, 128);
        String fluid = "Empty";
        if (this.valve.getTankConfig().getFluidStack() != null) {
            fluid = this.valve.getTankConfig().getFluidStack().getLocalizedName();
        }
        this.func_73732_a(this.field_146289_q, fluid, this.left + this.xSize_Valve / 2, this.top + 6, 0xFFFFFF);
        FluidStack stack = null;
        if (this.valve.getTankConfig() != null && this.valve.getTankConfig().getFluidTank() != null && (stack = this.valve.getTankConfig().getFluidTank().getFluid()) != null) {
            int height = Math.min(89, (int)Math.ceil((float)this.valve.getTankConfig().getFluidAmount() / (float)this.valve.getTankConfig().getFluidCapacity() * 89.0f));
            this.drawFluid(this.left + 20, this.top + 27 + (89 - height), stack, 48, height);
        }
        super.func_73863_a(x, y, partialTicks);
        if (this.tile instanceof INameableTile) {
            this.drawTileName(this.left, this.top);
        }
        if (this.mouseX >= this.left + 62 && this.mouseX < this.left + 62 + 8 && this.mouseY >= this.top + 26 && this.mouseY < this.top + 26 + 8) {
            this.lockedFluidHoveringText();
        } else if (stack != null) {
            this.fluidHoveringText(fluid, 20, 27, 89);
        }
        GlStateManager.func_179121_F();
    }

    private void drawGUINoValve(int x, int y, float partialTicks) {
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(tex_no_valve);
        ((Object)((Object)this)).getClass();
        this.func_73729_b(this.left, this.top, 0, 0, this.xSize_NoValve, 128);
        String fluid = "Empty";
        if (this.valve.getTankConfig().getFluidStack() != null) {
            fluid = this.valve.getTankConfig().getFluidStack().getLocalizedName();
        }
        this.func_73732_a(this.field_146289_q, fluid, this.left + this.xSize_NoValve / 2, this.top + 6, 0xFFFFFF);
        FluidStack stack = null;
        if (this.valve.getTankConfig() != null && this.valve.getTankConfig().getFluidTank() != null && (stack = this.valve.getTankConfig().getFluidTank().getFluid()) != null) {
            int height = Math.min(89, (int)Math.ceil((float)this.valve.getTankConfig().getFluidAmount() / (float)this.valve.getTankConfig().getFluidCapacity() * 89.0f));
            this.drawFluid(this.left + 24, this.top + 27 + (89 - height), stack, 48, height);
        }
        super.func_73863_a(x, y, partialTicks);
        if (this.mouseX >= this.left + 66 && this.mouseX < this.left + 66 + 8 && this.mouseY >= this.top + 26 && this.mouseY < this.top + 26 + 8) {
            this.lockedFluidHoveringText();
        } else if (stack != null) {
            this.fluidHoveringText(fluid, 24, 27, 89);
        }
        GlStateManager.func_179121_F();
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.mouseX = x;
        this.mouseY = y;
        if (this.isNonValve) {
            this.drawGUINoValve(x, y, partialTicks);
        } else {
            this.drawGUIValve(x, y, partialTicks);
        }
    }

    private void drawTileName(int x, int y) {
        int length = this.field_146289_q.func_78256_a("Tile Name");
        this.field_146289_q.func_78276_b(ChatFormatting.BLACK + "Tile Name", x + 86 + length / 2, y + 90, Color.white.getRGB());
        this.tileName.func_146194_f();
    }

    private void lockedFluidHoveringText() {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add("Fluid " + (this.valve.getTankConfig().isFluidLocked() ? ChatFormatting.RED + "Locked" : ChatFormatting.GREEN + "Unlocked"));
        if (this.valve.getTankConfig().isFluidLocked()) {
            texts.add(ChatFormatting.GRAY + "Locked to: " + this.valve.getTankConfig().getLockedFluid().getLocalizedName());
        }
        GlStateManager.func_179094_E();
        this.drawHoveringText(texts, this.mouseX, this.mouseY, this.field_146289_q);
        GlStateManager.func_179121_F();
    }

    private void fluidHoveringText(String fluid, int tank_x, int tank_y, int height) {
        if (this.mouseX >= this.left + tank_x && this.mouseX < this.left + tank_x + 48 && this.mouseY >= this.top + tank_y && this.mouseY < this.top + tank_y + height) {
            ArrayList<String> texts = new ArrayList<String>();
            texts.add(fluid);
            texts.add(ChatFormatting.GRAY + GenericUtil.intToFancyNumber(this.valve.getTankConfig().getFluidAmount()) + " / " + GenericUtil.intToFancyNumber(this.valve.getTankConfig().getFluidCapacity()) + " mB");
            GlStateManager.func_179094_E();
            this.drawHoveringText(texts, this.mouseX, this.mouseY, this.field_146289_q);
            GlStateManager.func_179121_F();
        }
    }

    public void func_146284_a(GuiButton btn) {
        if (btn == this.lockFluidButton) {
            GuiButtonLockFluid toggle = (GuiButtonLockFluid)btn;
            this.masterValve.toggleFluidLock(toggle.getState());
            toggle.setState(this.masterValve.getTankConfig().isFluidLocked());
            NetworkHandler.sendPacketToServer(new FFSPacket.Server.UpdateFluidLock(this.masterValve));
        }
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null) {
            return;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        ClientRenderHelper.setBlockTextureSheet();
        int color = fluid.getFluid().getColor(fluid);
        ClientRenderHelper.setGLColorFromInt(color);
        this.drawTiledTexture(x, y, ClientRenderHelper.getTexture(fluid.getFluid().getStill(fluid)), width, height);
        GL11.glPopMatrix();
    }

    public void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(minU, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

