/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.compat.cnb;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.compat.cnb.CNBAPIAccess;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.GenericUtil;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.BitQueryResults;
import mod.chiselsandbits.api.EventBlockBitPostModification;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum CNBCompatibility {
    INSTANCE;


    public boolean isValid(World world, BlockPos pos, EnumFacing facing) {
        IChiselAndBitsAPI cbAPI = CNBAPIAccess.apiInstance;
        if (cbAPI.isBlockChiseled(world, pos)) {
            try {
                Walls p = Walls.valueOf(facing.toString().toUpperCase());
                IBitAccess bitAccess = cbAPI.getBitAccess(world, pos);
                BitQueryResults results = bitAccess.queryBitRange(p.posA, p.posB);
                if (results.solid == 256) {
                    return true;
                }
            }
            catch (APIExceptions.CannotBeChiseled cannotBeChiseled) {
                cannotBeChiseled.printStackTrace();
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onBlockBitModified(EventBlockBitPostModification event) {
        if (event.getWorld() == null) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!FancyFluidStorage.tankManager.isPartOfTank(event.getWorld(), event.getPos())) {
            return;
        }
        AbstractTankValve valve = FancyFluidStorage.tankManager.getValveForBlock(event.getWorld(), event.getPos());
        if (valve == null || !valve.isValid()) {
            return;
        }
        EnumFacing inside = GenericUtil.getInsideForTankFrame(valve.getAirBlocks(), event.getPos());
        if (!this.isValid(event.getWorld(), event.getPos(), inside)) {
            valve.breakTank();
        }
    }

    private static enum Walls {
        DOWN(new BlockPos(0, 0, 0), new BlockPos(15, 0, 15)),
        UP(new BlockPos(0, 15, 0), new BlockPos(15, 15, 15)),
        NORTH(new BlockPos(0, 0, 0), new BlockPos(15, 15, 0)),
        SOUTH(new BlockPos(0, 0, 15), new BlockPos(15, 15, 15)),
        WEST(new BlockPos(0, 0, 0), new BlockPos(0, 15, 15)),
        EAST(new BlockPos(15, 0, 0), new BlockPos(15, 15, 15));

        private final BlockPos posA;
        private final BlockPos posB;

        private Walls(BlockPos a, BlockPos b) {
            this.posA = a;
            this.posB = b;
        }
    }
}

