/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.compat.top;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TankInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "ffs";
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
        AbstractTankValve valve = null;
        if (FancyFluidStorage.tankManager.isPartOfTank(world, iProbeHitData.getPos())) {
            valve = FancyFluidStorage.tankManager.getValveForBlock(world, iProbeHitData.getPos());
        }
        if (valve != null) {
            IProbeInfo vert = iProbeInfo.vertical();
            vert.text(TextFormatting.GRAY + "" + TextFormatting.ITALIC + "Part of a tank");
            this.addFluidInfo(vert, Config.getDefaultConfig(), valve.getTankConfig().getFluidStack(), valve.getTankConfig().getFluidCapacity());
        }
    }

    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
        int contents;
        int n = contents = fluidStack == null ? 0 : fluidStack.amount;
        if (fluidStack != null) {
            probeInfo.text("Liquid: " + fluidStack.getLocalizedName());
        }
        if (config.getTankMode() == 1) {
            probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat));
        } else {
            probeInfo.text(TextFormatting.GREEN + ElementProgress.format((long)contents, (NumberFormat)Config.tankFormat, (String)"mB"));
        }
    }
}

